/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;

public class StoreFactory {
    private final DatabaseLayout databaseLayout;
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final LogProvider logProvider;
    private final PageCache pageCache;
    private final RecordFormats recordFormats;
    private final OpenOption[] openOptions;
    private final VersionContextSupplier versionContextSupplier;

    public StoreFactory(DatabaseLayout directoryStructure, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, LogProvider logProvider, VersionContextSupplier versionContextSupplier) {
        this(directoryStructure, config, idGeneratorFactory, pageCache, fileSystemAbstraction, RecordFormatSelector.selectForStoreOrConfig(config, directoryStructure, fileSystemAbstraction, pageCache, logProvider), logProvider, versionContextSupplier, new OpenOption[0]);
    }

    public StoreFactory(DatabaseLayout databaseLayout, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, RecordFormats recordFormats, LogProvider logProvider, VersionContextSupplier versionContextSupplier, OpenOption ... openOptions) {
        this.databaseLayout = databaseLayout;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.versionContextSupplier = versionContextSupplier;
        this.recordFormats = recordFormats;
        this.openOptions = openOptions;
        new RecordFormatPropertyConfigurator(recordFormats, config).configure();
        this.logProvider = logProvider;
        this.pageCache = pageCache;
    }

    public NeoStores openAllNeoStores() {
        return this.openNeoStores(false, StoreType.values());
    }

    public NeoStores openAllNeoStores(boolean createStoreIfNotExists) {
        return this.openNeoStores(createStoreIfNotExists, StoreType.values());
    }

    public NeoStores openNeoStores(StoreType ... storeTypes) {
        return this.openNeoStores(false, storeTypes);
    }

    public NeoStores openNeoStores(boolean createStoreIfNotExists, StoreType ... storeTypes) {
        if (createStoreIfNotExists) {
            try {
                this.fileSystemAbstraction.mkdirs(this.databaseLayout.databaseDirectory());
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Could not create database directory: " + this.databaseLayout.databaseDirectory(), e);
            }
        }
        return new NeoStores(this.databaseLayout, this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.fileSystemAbstraction, this.versionContextSupplier, this.recordFormats, createStoreIfNotExists, storeTypes, this.openOptions);
    }
}

