/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id.validation;

import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdCapacityExceededException;
import org.neo4j.kernel.impl.store.id.validation.NegativeIdException;
import org.neo4j.kernel.impl.store.id.validation.ReservedIdException;

public final class IdValidator {
    private IdValidator() {
    }

    public static boolean isReservedId(long id) {
        return id == 0xFFFFFFFFL;
    }

    public static void assertValidId(IdType idType, long id, long maxId) {
        if (IdValidator.isReservedId(id)) {
            throw new ReservedIdException(id);
        }
        IdValidator.assertIdWithinCapacity(idType, id, maxId);
    }

    public static void assertIdWithinCapacity(IdType idType, long id, long maxId) {
        if (id < 0L) {
            throw new NegativeIdException(id);
        }
        if (id > maxId) {
            throw new IdCapacityExceededException(idType, id, maxId);
        }
    }

    public static boolean hasReservedIdInRange(long startIdInclusive, long endIdExclusive) {
        return startIdInclusive <= 0xFFFFFFFFL && endIdExclusive > 0xFFFFFFFFL;
    }
}

