/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.PropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexActivator;
import org.neo4j.kernel.impl.transaction.command.IndexUpdatesWork;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.transaction.state.OnlineIndexUpdates;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class IndexBatchTransactionApplier
extends BatchTransactionApplier.Adapter {
    private final IndexingService indexingService;
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync;
    private final WorkSync<IndexingUpdateService, IndexUpdatesWork> indexUpdatesSync;
    private final SingleTransactionApplier transactionApplier;
    private final IndexActivator indexActivator;
    private final PropertyStore propertyStore;
    private List<NodeLabelUpdate> labelUpdates;
    private IndexUpdates indexUpdates;
    private long txId;

    public IndexBatchTransactionApplier(IndexingService indexingService, WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync, WorkSync<IndexingUpdateService, IndexUpdatesWork> indexUpdatesSync, NodeStore nodeStore, RelationshipStore relationshipStore, PropertyStore propertyStore, IndexActivator indexActivator) {
        this.indexingService = indexingService;
        this.labelScanStoreSync = labelScanStoreSync;
        this.indexUpdatesSync = indexUpdatesSync;
        this.propertyStore = propertyStore;
        this.transactionApplier = new SingleTransactionApplier(nodeStore, relationshipStore);
        this.indexActivator = indexActivator;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) {
        this.txId = transaction.transactionId();
        return this.transactionApplier;
    }

    private void applyPendingLabelAndIndexUpdates() throws IOException {
        AsyncApply labelUpdatesApply = null;
        if (this.labelUpdates != null) {
            labelUpdatesApply = this.labelScanStoreSync.applyAsync((Work)new LabelUpdateWork(this.labelUpdates));
            this.labelUpdates = null;
        }
        if (this.indexUpdates != null && this.indexUpdates.hasUpdates()) {
            try {
                this.indexUpdatesSync.apply((Work)new IndexUpdatesWork(this.indexUpdates));
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush index updates", e);
            }
            this.indexUpdates = null;
        }
        if (labelUpdatesApply != null) {
            try {
                labelUpdatesApply.await();
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush label updates", e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.applyPendingLabelAndIndexUpdates();
    }

    private class SingleTransactionApplier
    extends TransactionApplier.Adapter {
        private final NodeStore nodeStore;
        private RelationshipStore relationshipStore;
        private final PropertyCommandsExtractor indexUpdatesExtractor = new PropertyCommandsExtractor();
        private List<StoreIndexDescriptor> createdIndexes;

        SingleTransactionApplier(NodeStore nodeStore, RelationshipStore relationshipStore) {
            this.nodeStore = nodeStore;
            this.relationshipStore = relationshipStore;
        }

        @Override
        public void close() throws Exception {
            if (this.indexUpdatesExtractor.containsAnyEntityOrPropertyUpdate()) {
                this.indexUpdates().feed(this.indexUpdatesExtractor.getNodeCommands(), this.indexUpdatesExtractor.getRelationshipCommands());
                this.indexUpdatesExtractor.close();
            }
            if (this.createdIndexes != null) {
                IndexBatchTransactionApplier.this.indexingService.createIndexes(this.createdIndexes.toArray(new StoreIndexDescriptor[0]));
                this.createdIndexes = null;
            }
        }

        private IndexUpdates indexUpdates() {
            if (IndexBatchTransactionApplier.this.indexUpdates == null) {
                IndexBatchTransactionApplier.this.indexUpdates = new OnlineIndexUpdates(this.nodeStore, this.relationshipStore, IndexBatchTransactionApplier.this.indexingService, new PropertyPhysicalToLogicalConverter(IndexBatchTransactionApplier.this.propertyStore));
            }
            return IndexBatchTransactionApplier.this.indexUpdates;
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) {
            NodeRecord before = (NodeRecord)command.getBefore();
            NodeRecord after = (NodeRecord)command.getAfter();
            NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(before);
            NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(after);
            if (!labelFieldBefore.isInlined() || !labelFieldAfter.isInlined() || before.getLabelField() != after.getLabelField()) {
                long[] labelsBefore = labelFieldBefore.getIfLoaded();
                long[] labelsAfter = labelFieldAfter.getIfLoaded();
                if (labelsBefore != null && labelsAfter != null) {
                    if (IndexBatchTransactionApplier.this.labelUpdates == null) {
                        IndexBatchTransactionApplier.this.labelUpdates = new ArrayList();
                    }
                    IndexBatchTransactionApplier.this.labelUpdates.add(NodeLabelUpdate.labelChanges(command.getKey(), labelsBefore, labelsAfter, IndexBatchTransactionApplier.this.txId));
                }
            }
            return this.indexUpdatesExtractor.visitNodeCommand(command);
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
            return this.indexUpdatesExtractor.visitRelationshipCommand(command);
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) {
            return this.indexUpdatesExtractor.visitPropertyCommand(command);
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            block12: {
                SchemaRule schemaRule;
                block11: {
                    schemaRule = command.getSchemaRule();
                    if (!(command.getSchemaRule() instanceof StoreIndexDescriptor)) break block11;
                    StoreIndexDescriptor indexRule = (StoreIndexDescriptor)schemaRule;
                    IndexBatchTransactionApplier.this.applyPendingLabelAndIndexUpdates();
                    switch (command.getMode()) {
                        case UPDATE: {
                            if (indexRule.canSupportUniqueConstraint()) {
                                IndexBatchTransactionApplier.this.indexActivator.activateIndex(schemaRule.getId());
                                break;
                            }
                            break block12;
                        }
                        case CREATE: {
                            this.createdIndexes = this.createdIndexes == null ? new ArrayList() : this.createdIndexes;
                            this.createdIndexes.add(indexRule);
                            break;
                        }
                        case DELETE: {
                            IndexBatchTransactionApplier.this.indexingService.dropIndex(indexRule);
                            IndexBatchTransactionApplier.this.indexActivator.indexDropped(schemaRule.getId());
                            break;
                        }
                        default: {
                            throw new IllegalStateException(command.getMode().name());
                        }
                    }
                    break block12;
                }
                if (schemaRule instanceof ConstraintRule) {
                    ConstraintRule constraintRule = (ConstraintRule)schemaRule;
                    switch (command.getMode()) {
                        case UPDATE: 
                        case CREATE: {
                            IndexBatchTransactionApplier.this.indexingService.putConstraint(constraintRule);
                            break;
                        }
                        case DELETE: {
                            IndexBatchTransactionApplier.this.indexingService.removeConstraint(constraintRule.getId());
                            break;
                        }
                        default: {
                            throw new IllegalStateException(command.getMode().name());
                        }
                    }
                }
            }
            return false;
        }
    }
}

