/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.impl.storageengine.impl.recordstorage.Loaders;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChanges;
import org.neo4j.kernel.impl.util.statistics.IntCounter;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class RecordChangeSet
implements RecordAccessSet {
    private final RecordAccess<NodeRecord, Void> nodeRecords;
    private final RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords;
    private final RecordAccess<RelationshipRecord, Void> relRecords;
    private final RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords;
    private final RecordAccess<SchemaRecord, SchemaRule> schemaRuleChanges;
    private final RecordAccess<PropertyKeyTokenRecord, Void> propertyKeyTokenChanges;
    private final RecordAccess<LabelTokenRecord, Void> labelTokenChanges;
    private final RecordAccess<RelationshipTypeTokenRecord, Void> relationshipTypeTokenChanges;
    private final IntCounter changeCounter = new IntCounter();

    public RecordChangeSet(Loaders loaders) {
        this(loaders.nodeLoader(), loaders.propertyLoader(), loaders.relationshipLoader(), loaders.relationshipGroupLoader(), loaders.schemaRuleLoader(), loaders.propertyKeyTokenLoader(), loaders.labelTokenLoader(), loaders.relationshipTypeTokenLoader());
    }

    public RecordChangeSet(RecordAccess.Loader<NodeRecord, Void> nodeLoader, RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader, RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader, RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader, RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader, RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader, RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader, RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader) {
        this.nodeRecords = new RecordChanges<NodeRecord, Void>(nodeLoader, this.changeCounter);
        this.propertyRecords = new RecordChanges<PropertyRecord, PrimitiveRecord>(propertyLoader, this.changeCounter);
        this.relRecords = new RecordChanges<RelationshipRecord, Void>(relationshipLoader, this.changeCounter);
        this.relGroupRecords = new RecordChanges<RelationshipGroupRecord, Integer>(relationshipGroupLoader, this.changeCounter);
        this.schemaRuleChanges = new RecordChanges<SchemaRecord, SchemaRule>(schemaRuleLoader, this.changeCounter);
        this.propertyKeyTokenChanges = new RecordChanges<PropertyKeyTokenRecord, Void>(propertyKeyTokenLoader, this.changeCounter);
        this.labelTokenChanges = new RecordChanges<LabelTokenRecord, Void>(labelTokenLoader, this.changeCounter);
        this.relationshipTypeTokenChanges = new RecordChanges<RelationshipTypeTokenRecord, Void>(relationshipTypeTokenLoader, this.changeCounter);
    }

    @Override
    public RecordAccess<NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<RelationshipRecord, Void> getRelRecords() {
        return this.relRecords;
    }

    @Override
    public RecordAccess<RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relGroupRecords;
    }

    @Override
    public RecordAccess<SchemaRecord, SchemaRule> getSchemaRuleChanges() {
        return this.schemaRuleChanges;
    }

    @Override
    public RecordAccess<PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenChanges;
    }

    @Override
    public RecordAccess<LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenChanges;
    }

    @Override
    public RecordAccess<RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenChanges;
    }

    @Override
    public boolean hasChanges() {
        return this.changeCounter.value() > 0;
    }

    @Override
    public int changeSize() {
        return this.changeCounter.value();
    }

    @Override
    public void close() {
        if (this.hasChanges()) {
            this.nodeRecords.close();
            this.propertyRecords.close();
            this.relRecords.close();
            this.schemaRuleChanges.close();
            this.relGroupRecords.close();
            this.propertyKeyTokenChanges.close();
            this.labelTokenChanges.close();
            this.relationshipTypeTokenChanges.close();
            this.changeCounter.clear();
        }
    }
}

