/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import org.neo4j.kernel.impl.storageengine.impl.recordstorage.Loaders;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccess;

public class DirectRecordAccessSet
implements RecordAccessSet {
    private final DirectRecordAccess<NodeRecord, Void> nodeRecords;
    private final DirectRecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords;
    private final DirectRecordAccess<RelationshipRecord, Void> relationshipRecords;
    private final DirectRecordAccess<RelationshipGroupRecord, Integer> relationshipGroupRecords;
    private final DirectRecordAccess<PropertyKeyTokenRecord, Void> propertyKeyTokenRecords;
    private final DirectRecordAccess<RelationshipTypeTokenRecord, Void> relationshipTypeTokenRecords;
    private final DirectRecordAccess<LabelTokenRecord, Void> labelTokenRecords;
    private final DirectRecordAccess[] all;

    public DirectRecordAccessSet(NeoStores neoStores) {
        this(neoStores.getNodeStore(), neoStores.getPropertyStore(), neoStores.getRelationshipStore(), neoStores.getRelationshipGroupStore(), neoStores.getPropertyKeyTokenStore(), neoStores.getRelationshipTypeTokenStore(), neoStores.getLabelTokenStore(), neoStores.getSchemaStore());
    }

    public DirectRecordAccessSet(RecordStore<NodeRecord> nodeStore, PropertyStore propertyStore, RecordStore<RelationshipRecord> relationshipStore, RecordStore<RelationshipGroupRecord> relationshipGroupStore, RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore, RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore, RecordStore<LabelTokenRecord> labelTokenStore, SchemaStore schemaStore) {
        Loaders loaders = new Loaders(nodeStore, propertyStore, relationshipStore, relationshipGroupStore, propertyKeyTokenStore, relationshipTypeTokenStore, labelTokenStore, schemaStore);
        this.nodeRecords = new DirectRecordAccess<NodeRecord, Void>(nodeStore, loaders.nodeLoader());
        this.propertyRecords = new DirectRecordAccess<PropertyRecord, PrimitiveRecord>(propertyStore, loaders.propertyLoader());
        this.relationshipRecords = new DirectRecordAccess<RelationshipRecord, Void>(relationshipStore, loaders.relationshipLoader());
        this.relationshipGroupRecords = new DirectRecordAccess<RelationshipGroupRecord, Integer>(relationshipGroupStore, loaders.relationshipGroupLoader());
        this.propertyKeyTokenRecords = new DirectRecordAccess<PropertyKeyTokenRecord, Void>(propertyKeyTokenStore, loaders.propertyKeyTokenLoader());
        this.relationshipTypeTokenRecords = new DirectRecordAccess<RelationshipTypeTokenRecord, Void>(relationshipTypeTokenStore, loaders.relationshipTypeTokenLoader());
        this.labelTokenRecords = new DirectRecordAccess<LabelTokenRecord, Void>(labelTokenStore, loaders.labelTokenLoader());
        this.all = new DirectRecordAccess[]{this.nodeRecords, this.propertyRecords, this.relationshipRecords, this.relationshipGroupRecords, this.propertyKeyTokenRecords, this.relationshipTypeTokenRecords, this.labelTokenRecords};
    }

    @Override
    public RecordAccess<NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<RelationshipRecord, Void> getRelRecords() {
        return this.relationshipRecords;
    }

    @Override
    public RecordAccess<RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relationshipGroupRecords;
    }

    @Override
    public RecordAccess<SchemaRecord, SchemaRule> getSchemaRuleChanges() {
        throw new UnsupportedOperationException("Not needed. Implement if needed");
    }

    @Override
    public RecordAccess<PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenRecords;
    }

    @Override
    public RecordAccess<LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenRecords;
    }

    @Override
    public RecordAccess<RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenRecords;
    }

    @Override
    public void close() {
        this.commit();
        for (DirectRecordAccess access : this.all) {
            access.close();
        }
    }

    public void commit() {
        for (DirectRecordAccess access : this.all) {
            access.commit();
        }
    }

    @Override
    public boolean hasChanges() {
        for (DirectRecordAccess access : this.all) {
            if (access.changeSize() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int changeSize() {
        int total = 0;
        for (DirectRecordAccess access : this.all) {
            total += access.changeSize();
        }
        return total;
    }
}

