/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class EncodeGroupsStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private long nextId = -1L;
    private final RecordStore<RelationshipGroupRecord> store;

    public EncodeGroupsStep(StageControl control, Configuration config, RecordStore<RelationshipGroupRecord> store) {
        super(control, "ENCODE", config, 1, new StatsProvider[0]);
        this.store = store;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender) {
        int groupStartIndex = 0;
        for (int i = 0; i < batch.length; ++i) {
            long l;
            boolean lastInChain;
            RelationshipGroupRecord group = batch[i];
            long count = group.getNext();
            boolean bl = lastInChain = count == 0L;
            if (this.nextId == -1L) {
                l = this.store.nextId();
                this.nextId = this.nextId;
            } else {
                l = this.nextId;
            }
            group.setId(l);
            if (!lastInChain) {
                this.nextId = this.store.nextId();
                group.setNext(this.nextId);
                continue;
            }
            this.nextId = -1L;
            group.setNext(-1L);
            for (int j = groupStartIndex; j <= i; ++j) {
                this.store.prepareForCommit(batch[j]);
            }
            groupStartIndex = i + 1;
        }
        assert (groupStartIndex == batch.length);
        sender.send(batch);
    }
}

