/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.neo4j.causalclustering.discovery.SecurePassword;
import org.neo4j.ssl.SslPolicy;

public class DiscoverySSLContextFactory {
    public static final String PROTOCOL = "TLS";
    private final SslPolicy sslPolicy;

    public DiscoverySSLContextFactory(SslPolicy sslPolicy) {
        this.sslPolicy = sslPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLContext sslContext() {
        try (SecurePassword securePassword = new SecurePassword(32, new SecureRandom());){
            char[] password = securePassword.password();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = this.sslPolicy.getKeyStore(password, password);
            keyManagerFactory.init(keyStore, password);
            SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = this.sslPolicy.getTrustManagerFactory().getTrustManagers();
            sslContext.init(keyManagers, trustManagers, null);
            SSLContext sSLContext = sslContext;
            return sSLContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException("Error creating SSL context", e);
        }
    }
}

