/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery;

import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SSLConfig;
import com.neo4j.causalclustering.discovery.HazelcastSslContextFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

public class HazelcastSslConfiguration {
    public static void configureSsl(NetworkConfig networkConfig, SslPolicy sslPolicy, LogProvider logProvider) {
        SSLConfig sslConfig = HazelcastSslConfiguration.commonSslConfig(sslPolicy, logProvider);
        networkConfig.setSSLConfig(sslConfig);
    }

    public static void configureSsl(ClientNetworkConfig clientNetworkConfig, SslPolicy sslPolicy, LogProvider logProvider) {
        SSLConfig sslConfig = HazelcastSslConfiguration.commonSslConfig(sslPolicy, logProvider);
        clientNetworkConfig.setSSLConfig(sslConfig);
    }

    private static SSLConfig commonSslConfig(SslPolicy sslPolicy, LogProvider logProvider) {
        SSLConfig sslConfig = new SSLConfig();
        if (sslPolicy == null) {
            return sslConfig;
        }
        sslConfig.setFactoryImplementation((Object)new HazelcastSslContextFactory(sslPolicy, logProvider)).setEnabled(true);
        switch (sslPolicy.getClientAuth()) {
            case REQUIRE: {
                sslConfig.setProperty("javax.net.ssl.mutualAuthentication", "REQUIRED");
                break;
            }
            case OPTIONAL: {
                sslConfig.setProperty("javax.net.ssl.mutualAuthentication", "OPTIONAL");
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported: " + sslPolicy.getClientAuth());
            }
        }
        return sslConfig;
    }
}

