/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery;

import com.hazelcast.nio.ssl.SSLContextFactory;
import com.neo4j.causalclustering.discovery.DiscoverySSLContextFactory;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

class HazelcastSslContextFactory
implements SSLContextFactory {
    private final SslPolicy sslPolicy;
    private final Log log;

    HazelcastSslContextFactory(SslPolicy sslPolicy, LogProvider logProvider) {
        this.sslPolicy = sslPolicy;
        this.log = logProvider.getLog(this.getClass());
    }

    public void init(Properties properties) {
    }

    public SSLContext getSSLContext() {
        if (this.sslPolicy.getTlsVersions() != null) {
            this.log.warn(String.format("Restricting TLS versions through policy not supported. System defaults for %s family will be used.", "TLS"));
        }
        if (this.sslPolicy.getCipherSuites() != null) {
            this.log.warn("Restricting ciphers through policy not supported. System defaults will be used.");
        }
        return new DiscoverySSLContextFactory(this.sslPolicy).sslContext();
    }
}

