/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.client.ClusterClientReceptionist;
import akka.event.EventStream;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.neo4j.causalclustering.discovery.akka.TopologyState;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterIdSettingMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.CoreTopologyActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.CoreTopologyMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.RestartNeededListeningActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.TopologyBuilder;
import com.neo4j.causalclustering.discovery.akka.directory.DirectoryActor;
import com.neo4j.causalclustering.discovery.akka.directory.LeaderInfoSettingMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaTopologyActor;
import com.neo4j.causalclustering.discovery.akka.system.ActorSystemLifecycle;
import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.AbstractCoreTopologyService;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyListenerService;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RetryStrategy;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.SafeLifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.util.VisibleForTesting;

public class AkkaCoreTopologyService
extends AbstractCoreTopologyService {
    private Optional<ActorRef> coreTopologyActorRef = Optional.empty();
    private Optional<ActorRef> directoryActorRef = Optional.empty();
    private final ActorSystemLifecycle actorSystemLifecycle;
    private final LogProvider logProvider;
    private final TopologyServiceRetryStrategy catchupAddressRetryStrategy;
    private final TopologyState topologyState;
    private final RetryStrategy<Void, Boolean> restartRetryStrategy;
    private final ExecutorService executor;
    private final Clock clock;
    private volatile LeaderInfo leaderInfo = LeaderInfo.INITIAL;

    public AkkaCoreTopologyService(Config config, MemberId myself, ActorSystemLifecycle actorSystemLifecycle, LogProvider logProvider, LogProvider userLogProvider, TopologyServiceRetryStrategy catchupAddressRetryStrategy, RetryStrategy<Void, Boolean> restartRetryStrategy, ExecutorService executor, Clock clock) {
        super(config, myself, logProvider, userLogProvider);
        this.actorSystemLifecycle = actorSystemLifecycle;
        this.logProvider = logProvider;
        this.catchupAddressRetryStrategy = catchupAddressRetryStrategy;
        this.restartRetryStrategy = restartRetryStrategy;
        this.executor = executor;
        this.clock = clock;
        this.topologyState = new TopologyState(config, logProvider, arg_0 -> ((CoreTopologyListenerService)this.listenerService).notifyListeners(arg_0));
    }

    public void start0() {
        this.actorSystemLifecycle.createClusterActorSystem();
        SourceQueueWithComplete coreTopologySink = this.actorSystemLifecycle.queueMostRecent(this::onCoreTopologyMessage);
        SourceQueueWithComplete rrTopologySink = this.actorSystemLifecycle.queueMostRecent(this.topologyState::onTopologyUpdate);
        SourceQueueWithComplete directorySink = this.actorSystemLifecycle.queueMostRecent(this.topologyState::onDbLeaderUpdate);
        Cluster cluster = this.actorSystemLifecycle.cluster();
        ActorRef replicator = this.actorSystemLifecycle.replicator();
        ActorRef rrTopologyActor = this.readReplicaTopologyActor(rrTopologySink);
        ActorRef coreTopologyActor = this.coreTopologyActor(cluster, replicator, coreTopologySink, rrTopologyActor);
        ActorRef directoryActor = this.directoryActor(cluster, replicator, directorySink, rrTopologyActor);
        this.startRestartNeededListeningActor(cluster);
        this.coreTopologyActorRef = Optional.of(coreTopologyActor);
        this.directoryActorRef = Optional.of(directoryActor);
    }

    private ActorRef coreTopologyActor(Cluster cluster, ActorRef replicator, SourceQueueWithComplete<CoreTopologyMessage> topologySink, ActorRef rrTopologyActor) {
        TopologyBuilder topologyBuilder = new TopologyBuilder(this.config, cluster.selfUniqueAddress(), this.logProvider);
        Props coreTopologyProps = CoreTopologyActor.props(this.myself, topologySink, rrTopologyActor, replicator, cluster, topologyBuilder, this.config, this.logProvider);
        return this.actorSystemLifecycle.applicationActorOf(coreTopologyProps, "cc-core-topology-actor");
    }

    private ActorRef directoryActor(Cluster cluster, ActorRef replicator, SourceQueueWithComplete<Map<String, LeaderInfo>> directorySink, ActorRef rrTopologyActor) {
        Props directoryProps = DirectoryActor.props(cluster, replicator, directorySink, rrTopologyActor, this.logProvider);
        return this.actorSystemLifecycle.applicationActorOf(directoryProps, "cc-directory-actor");
    }

    private ActorRef readReplicaTopologyActor(SourceQueueWithComplete<ReadReplicaTopology> topologySink) {
        ClusterClientReceptionist receptionist = this.actorSystemLifecycle.clusterClientReceptionist();
        Props readReplicaTopologyProps = ReadReplicaTopologyActor.props(topologySink, receptionist, this.logProvider, this.config, this.clock);
        return this.actorSystemLifecycle.applicationActorOf(readReplicaTopologyProps, "cc-rr-topology-actor");
    }

    private ActorRef startRestartNeededListeningActor(Cluster cluster) {
        Runnable restart = () -> this.executor.submit(this::restart);
        EventStream eventStream = this.actorSystemLifecycle.eventStream();
        Props props = RestartNeededListeningActor.props(restart, eventStream, cluster, this.logProvider);
        return this.actorSystemLifecycle.applicationActorOf(props, RestartNeededListeningActor.NAME);
    }

    private void onCoreTopologyMessage(CoreTopologyMessage coreTopologyMessage) {
        this.topologyState.onTopologyUpdate(coreTopologyMessage.coreTopology());
        this.actorSystemLifecycle.addSeenAddresses(coreTopologyMessage.akkaMembers());
    }

    public void stop0() throws Throwable {
        this.coreTopologyActorRef = Optional.empty();
        this.directoryActorRef = Optional.empty();
        this.actorSystemLifecycle.shutdown();
    }

    public boolean setClusterId(ClusterId clusterId, String dbName) {
        if (this.coreTopologyActorRef.isPresent()) {
            ActorRef actor = this.coreTopologyActorRef.get();
            actor.tell((Object)new ClusterIdSettingMessage(clusterId, dbName), ActorRef.noSender());
            return true;
        }
        return false;
    }

    public LeaderInfo getLeader() {
        return this.leaderInfo;
    }

    @VisibleForTesting
    public synchronized void restart() {
        if (!SafeLifecycle.State.RUN.equals((Object)this.state())) {
            this.log.info("Not restarting because not running. State is %s", new Object[]{this.state()});
            return;
        }
        this.userLog.info("Restarting discovery system after probable network partition");
        this.restartRetryStrategy.apply(null, this::doRestart, r -> r);
    }

    private boolean doRestart(Void ignored) {
        try {
            this.stop();
            this.start();
            this.userLog.info("Successfully restarted discovery system");
            return true;
        }
        catch (Throwable t) {
            this.userLog.error("Failed to restart discovery system", t);
            return false;
        }
    }

    public void setLeader0(LeaderInfo leaderInfo) {
        this.leaderInfo = leaderInfo;
        if (leaderInfo.memberId() != null || leaderInfo.isSteppingDown()) {
            this.directoryActorRef.ifPresent(actor -> actor.tell((Object)new LeaderInfoSettingMessage(leaderInfo, this.localDBName()), ActorRef.noSender()));
        }
    }

    public void handleStepDown0(LeaderInfo steppingDown) {
        this.setLeader0(steppingDown);
    }

    public String localDBName() {
        return this.topologyState.localDBName();
    }

    public CoreTopology allCoreServers() {
        return this.topologyState.coreTopology();
    }

    public CoreTopology localCoreServers() {
        return this.topologyState.localCoreTopology();
    }

    public ReadReplicaTopology allReadReplicas() {
        return this.topologyState.readReplicaTopology();
    }

    public ReadReplicaTopology localReadReplicas() {
        return this.topologyState.localReadReplicaTopology();
    }

    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
        return (Optional)this.catchupAddressRetryStrategy.apply((Object)upstream, this.topologyState::retrieveSocketAddress, Optional::isPresent);
    }

    public Map<MemberId, RoleInfo> allCoreRoles() {
        return this.topologyState.allCoreRoles();
    }

    @VisibleForTesting
    TopologyState topologyState() {
        return this.topologyState;
    }
}

