/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.client.ClusterClient;
import akka.cluster.client.ClusterClientSettings;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.neo4j.causalclustering.discovery.akka.TopologyState;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ClientTopologyActor;
import com.neo4j.causalclustering.discovery.akka.system.ActorSystemLifecycle;
import java.util.Map;
import java.util.Optional;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.SafeLifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class AkkaTopologyClient
extends SafeLifecycle
implements TopologyService {
    private final Config config;
    private final ActorSystemLifecycle actorSystemLifecycle;
    private final MemberId myself;
    private final Log log;
    private final LogProvider logProvider;
    private final TopologyState topologyState;

    public AkkaTopologyClient(Config config, LogProvider logProvider, MemberId myself, ActorSystemLifecycle actorSystemLifecycle) {
        this.config = config;
        this.myself = myself;
        this.actorSystemLifecycle = actorSystemLifecycle;
        this.topologyState = new TopologyState(config, logProvider, ignored -> {});
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.logProvider = logProvider;
    }

    public void start0() {
        this.actorSystemLifecycle.createClientActorSystem();
        this.startTopologyActors();
    }

    private void startTopologyActors() {
        ClusterClientSettings clusterClientSettings = this.actorSystemLifecycle.clusterClientSettings();
        ActorRef clusterClient = this.actorSystemLifecycle.systemActorOf(ClusterClient.props((ClusterClientSettings)clusterClientSettings), "cluster-client");
        SourceQueueWithComplete coreTopologySink = this.actorSystemLifecycle.queueMostRecent(this.topologyState::onTopologyUpdate);
        SourceQueueWithComplete rrTopologySink = this.actorSystemLifecycle.queueMostRecent(this.topologyState::onTopologyUpdate);
        SourceQueueWithComplete directorySink = this.actorSystemLifecycle.queueMostRecent(this.topologyState::onDbLeaderUpdate);
        Props clientTopologyProps = ClientTopologyActor.props(this.myself, coreTopologySink, rrTopologySink, directorySink, clusterClient, this.config, this.logProvider);
        this.actorSystemLifecycle.applicationActorOf(clientTopologyProps, "cc-client-topology-actor");
    }

    public void stop0() throws Throwable {
        this.actorSystemLifecycle.shutdown();
    }

    public String localDBName() {
        return this.topologyState.localDBName();
    }

    public CoreTopology allCoreServers() {
        return this.topologyState.coreTopology();
    }

    public ReadReplicaTopology allReadReplicas() {
        return this.topologyState.readReplicaTopology();
    }

    public CoreTopology localCoreServers() {
        return this.topologyState.localCoreTopology();
    }

    public ReadReplicaTopology localReadReplicas() {
        return this.topologyState.localReadReplicaTopology();
    }

    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
        return this.topologyState.retrieveSocketAddress(upstream);
    }

    public Map<MemberId, RoleInfo> allCoreRoles() {
        return this.topologyState.allCoreRoles();
    }

    public MemberId myself() {
        return this.myself;
    }
}

