/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka;

import com.neo4j.causalclustering.discovery.akka.AkkaCoreTopologyService;
import com.neo4j.causalclustering.discovery.akka.AkkaTopologyClient;
import com.neo4j.causalclustering.discovery.akka.system.ActorSystemFactory;
import com.neo4j.causalclustering.discovery.akka.system.ActorSystemLifecycle;
import com.neo4j.causalclustering.discovery.akka.system.JoinMessageFactory;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.causalclustering.discovery.RetryStrategy;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

public abstract class BaseAkkaDiscoveryServiceFactory
implements DiscoveryServiceFactory {
    private static final long RESTART_RETRY_DELAY_MS = 1000L;
    private static final long RESTART_RETRIES = 10L;

    protected abstract ActorSystemFactory actorSystemFactory(ExecutorService var1, Config var2, LogProvider var3);

    public CoreTopologyService coreTopologyService(Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider, RemoteMembersResolver remoteMembersResolver, TopologyServiceRetryStrategy topologyServiceRetryStrategy, Monitors monitors, Clock clock) {
        ExecutorService executor = this.executorService(config, jobScheduler);
        MultiRetryStrategy restartRetryStrategy = new MultiRetryStrategy(1000L, 10L, logProvider, BaseAkkaDiscoveryServiceFactory::sleep);
        return new AkkaCoreTopologyService(config, myself, this.actorSystemLifecycle(config, executor, logProvider, remoteMembersResolver), logProvider, userLogProvider, topologyServiceRetryStrategy, (RetryStrategy<Void, Boolean>)restartRetryStrategy, executor, clock);
    }

    private ExecutorService executorService(Config config, JobScheduler jobScheduler) {
        int parallelism = (Integer)config.get(CausalClusteringSettings.middleware_akka_default_parallelism_level);
        return jobScheduler.workStealingExecutorAsyncMode(Group.AKKA_TOPOLOGY_WORKER, parallelism);
    }

    static void sleep(long durationInMillis) {
        try {
            Thread.sleep(durationInMillis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public TopologyService readReplicaTopologyService(Config config, LogProvider logProvider, JobScheduler jobScheduler, MemberId myself, RemoteMembersResolver remoteMembersResolver, TopologyServiceRetryStrategy topologyServiceRetryStrategy) {
        return new AkkaTopologyClient(config, logProvider, myself, this.actorSystemLifecycle(config, this.executorService(config, jobScheduler), logProvider, remoteMembersResolver));
    }

    protected ActorSystemLifecycle actorSystemLifecycle(Config config, ExecutorService executor, LogProvider logProvider, RemoteMembersResolver resolver) {
        return new ActorSystemLifecycle(this.actorSystemFactory(executor, config, logProvider), resolver, new JoinMessageFactory(resolver), config, logProvider);
    }
}

