/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.cluster.Cluster;
import akka.cluster.UniqueAddress;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.ReplicatedData;
import akka.cluster.ddata.Replicator;
import akka.japi.pf.ReceiveBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import scala.concurrent.duration.FiniteDuration;

public abstract class BaseReplicatedDataActor<T extends ReplicatedData>
extends AbstractActor {
    private static final Replicator.WriteConsistency METADATA_CONSISTENCY = new Replicator.WriteAll(new FiniteDuration(10L, TimeUnit.SECONDS));
    protected final Cluster cluster;
    protected final ActorRef replicator;
    protected final Key<T> key;
    protected final Supplier<T> emptyData;
    protected T data;
    protected final Log log;

    protected BaseReplicatedDataActor(Cluster cluster, ActorRef replicator, Key<T> key, Supplier<T> emptyData, LogProvider logProvider) {
        this.cluster = cluster;
        this.replicator = replicator;
        this.key = key;
        this.emptyData = emptyData;
        this.data = (ReplicatedData)emptyData.get();
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public final void preStart() {
        this.sendInitialDataToReplicator();
        this.subscribeToReplicatorEvents((Replicator.ReplicatorMessage)new Replicator.Subscribe(this.key, this.getSelf()));
    }

    protected abstract void sendInitialDataToReplicator();

    public final void postStop() {
        this.subscribeToReplicatorEvents((Replicator.ReplicatorMessage)new Replicator.Unsubscribe(this.key, this.getSelf()));
        this.removeDataFromReplicator(this.cluster.selfUniqueAddress());
    }

    protected abstract void removeDataFromReplicator(UniqueAddress var1);

    public final AbstractActor.Receive createReceive() {
        ReceiveBuilder receiveBuilder = new ReceiveBuilder();
        this.handleReplicationEvents(receiveBuilder);
        this.handleCustomEvents(receiveBuilder);
        return receiveBuilder.build();
    }

    private void handleReplicationEvents(ReceiveBuilder builder) {
        builder.match(Replicator.Changed.class, c -> c.key().equals(this.key), message -> {
            ReplicatedData newData = message.dataValue();
            this.handleIncomingData(newData);
        }).match(Replicator.UpdateResponse.class, updated -> this.log.debug("Update: %s", new Object[]{updated}));
    }

    protected void handleCustomEvents(ReceiveBuilder builder) {
    }

    protected abstract void handleIncomingData(T var1);

    private void subscribeToReplicatorEvents(Replicator.ReplicatorMessage message) {
        this.replicator.tell((Object)message, this.getSelf());
    }

    protected void modifyReplicatedData(Key<T> key, Function<T, T> modify) {
        Replicator.Update update = new Replicator.Update(key, (ReplicatedData)this.emptyData.get(), METADATA_CONSISTENCY, modify);
        this.replicator.tell((Object)update, this.self());
    }
}

