/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka;

import com.neo4j.causalclustering.discovery.akka.DirectoryUpdateSink;
import com.neo4j.causalclustering.discovery.akka.TopologyUpdateSink;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.DiscoveryServerInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.Topology;
import org.neo4j.causalclustering.discovery.TopologyDifference;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class TopologyState
implements TopologyUpdateSink,
DirectoryUpdateSink {
    private final String localDBName;
    private final Log log;
    private final Consumer<CoreTopology> callback;
    private volatile Map<MemberId, AdvertisedSocketAddress> coreCatchupAddressMap;
    private volatile Map<MemberId, AdvertisedSocketAddress> rrCatchupAddressMap;
    private volatile Map<String, LeaderInfo> remoteDbLeaderMap;
    private volatile CoreTopology coreTopology = CoreTopology.EMPTY;
    private volatile CoreTopology localCoreTopology = CoreTopology.EMPTY;
    private volatile ReadReplicaTopology readReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile ReadReplicaTopology localReadReplicaTopology = ReadReplicaTopology.EMPTY;

    public TopologyState(Config config, LogProvider logProvider, Consumer<CoreTopology> listener) {
        this.localDBName = (String)config.get(CausalClusteringSettings.database);
        this.log = logProvider.getLog(this.getClass());
        this.coreCatchupAddressMap = Collections.emptyMap();
        this.rrCatchupAddressMap = Collections.emptyMap();
        this.remoteDbLeaderMap = Collections.emptyMap();
        this.callback = listener;
    }

    @Override
    public void onTopologyUpdate(CoreTopology newCoreTopology) {
        TopologyDifference diff = this.coreTopology.difference((Topology)newCoreTopology);
        this.coreTopology = newCoreTopology;
        this.localCoreTopology = newCoreTopology.filterTopologyByDb(this.localDBName);
        this.coreCatchupAddressMap = this.extractCatchupAddressesMap((Topology<?>)newCoreTopology);
        if (diff.hasChanges()) {
            this.log.info("Core topology changed %s", new Object[]{diff});
            this.callback.accept(newCoreTopology);
        }
    }

    @Override
    public void onTopologyUpdate(ReadReplicaTopology newReadReplicaTopology) {
        TopologyDifference diff = this.readReplicaTopology.difference((Topology)newReadReplicaTopology);
        this.readReplicaTopology = newReadReplicaTopology;
        this.localReadReplicaTopology = newReadReplicaTopology.filterTopologyByDb(this.localDBName);
        this.rrCatchupAddressMap = this.extractCatchupAddressesMap((Topology<?>)newReadReplicaTopology);
        if (diff.hasChanges()) {
            this.log.info("Read replica topology changed %s", new Object[]{diff});
        }
    }

    @Override
    public void onDbLeaderUpdate(Map<String, LeaderInfo> leaderInfoMap) {
        if (!leaderInfoMap.equals(this.remoteDbLeaderMap)) {
            this.log.info("Database leaders changed: %s", new Object[]{leaderInfoMap});
            this.remoteDbLeaderMap = leaderInfoMap;
        }
    }

    public Map<MemberId, RoleInfo> allCoreRoles() {
        Set leaders = this.remoteDbLeaderMap.values().stream().map(LeaderInfo::memberId).collect(Collectors.toSet());
        Set allCoreMembers = this.coreTopology.members().keySet();
        Function<MemberId, RoleInfo> roleMapper = m -> leaders.contains(m) ? RoleInfo.LEADER : RoleInfo.FOLLOWER;
        return allCoreMembers.stream().collect(Collectors.toMap(Function.identity(), roleMapper));
    }

    public String localDBName() {
        return this.localDBName;
    }

    public CoreTopology coreTopology() {
        return this.coreTopology;
    }

    public ReadReplicaTopology readReplicaTopology() {
        return this.readReplicaTopology;
    }

    public CoreTopology localCoreTopology() {
        return this.localCoreTopology;
    }

    public ReadReplicaTopology localReadReplicaTopology() {
        return this.localReadReplicaTopology;
    }

    private Map<MemberId, AdvertisedSocketAddress> extractCatchupAddressesMap(Topology<?> topology) {
        return topology.members().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((DiscoveryServerInfo)e.getValue()).getCatchupServer()));
    }

    public Optional<AdvertisedSocketAddress> retrieveSocketAddress(MemberId memberId) {
        Optional<AdvertisedSocketAddress> coreAddress = Optional.ofNullable(this.coreCatchupAddressMap.get(memberId));
        this.log.debug("Catchup address for core %s was %s", new Object[]{memberId, coreAddress});
        return coreAddress.isPresent() ? coreAddress : Optional.ofNullable(this.rrCatchupAddressMap.get(memberId));
    }
}

