/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import com.neo4j.causalclustering.discovery.akka.coretopology.CleanupMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterViewMessage;
import java.io.Serializable;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterDowningActor
extends AbstractActor {
    private final Cluster cluster;
    private final ActorRef metadataActor;
    private final Log log;

    public static Props props(Cluster cluster, ActorRef metadataActor, LogProvider logProvider) {
        return Props.create(ClusterDowningActor.class, (Creator & Serializable)() -> new ClusterDowningActor(cluster, metadataActor, logProvider));
    }

    public ClusterDowningActor(Cluster cluster, ActorRef metadataActor, LogProvider logProvider) {
        this.cluster = cluster;
        this.metadataActor = metadataActor;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ClusterViewMessage.class, this::handle).build();
    }

    private void handle(ClusterViewMessage clusterView) {
        if (clusterView.mostAreReachable()) {
            this.log.info("Downing members: %s", new Object[]{clusterView.unreachable()});
            clusterView.unreachable().stream().map(Member::address).forEach(arg_0 -> ((Cluster)this.cluster).down(arg_0));
            clusterView.unreachable().stream().map(Member::uniqueAddress).forEach(addr -> this.metadataActor.tell((Object)new CleanupMessage((UniqueAddress)addr), this.getSelf()));
        } else {
            this.log.info("In minority side of network partition? %s", new Object[]{clusterView});
        }
    }
}

