/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.UniqueAddress;
import akka.cluster.ddata.LWWMap;
import akka.cluster.ddata.LWWMapKey;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import com.neo4j.causalclustering.discovery.akka.BaseReplicatedDataActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterIdDirectoryMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterIdSettingMessage;
import java.io.Serializable;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.logging.LogProvider;

public class ClusterIdActor
extends BaseReplicatedDataActor<LWWMap<String, ClusterId>> {
    static final String CLUSTER_ID_PER_DB_KEY = "cluster-id-per-db-name";
    private final ActorRef coreTopologyActor;

    public ClusterIdActor(Cluster cluster, ActorRef replicator, ActorRef coreTopologyActor, LogProvider logProvider) {
        super(cluster, replicator, LWWMapKey.create((String)CLUSTER_ID_PER_DB_KEY), LWWMap::create, logProvider);
        this.coreTopologyActor = coreTopologyActor;
    }

    public static Props props(Cluster cluster, ActorRef replicator, ActorRef coreTopologyActor, LogProvider logProvider) {
        return Props.create(ClusterIdActor.class, (Creator & Serializable)() -> new ClusterIdActor(cluster, replicator, coreTopologyActor, logProvider));
    }

    @Override
    protected void sendInitialDataToReplicator() {
    }

    @Override
    protected void removeDataFromReplicator(UniqueAddress uniqueAddress) {
    }

    @Override
    protected void handleCustomEvents(ReceiveBuilder builder) {
        builder.match(ClusterIdSettingMessage.class, message -> {
            this.log.debug("Setting ClusterId: %s", new Object[]{message});
            this.modifyReplicatedData(this.key, map -> map.put(this.cluster, (Object)message.database(), (Object)message.clusterId()));
        });
    }

    @Override
    protected void handleIncomingData(LWWMap<String, ClusterId> newData) {
        this.data = ((LWWMap)this.data).merge(newData);
        this.coreTopologyActor.tell((Object)new ClusterIdDirectoryMessage((LWWMap<String, ClusterId>)((LWWMap)this.data)), this.getSelf());
    }
}

