/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.cluster.ddata.LWWMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.neo4j.causalclustering.identity.ClusterId;

public class ClusterIdDirectoryMessage {
    public static final ClusterIdDirectoryMessage EMPTY = new ClusterIdDirectoryMessage(Collections.emptyMap());
    private final Map<String, ClusterId> data;

    public ClusterIdDirectoryMessage(LWWMap<String, ClusterId> data) {
        this.data = data.getEntries();
    }

    public ClusterIdDirectoryMessage(Map<String, ClusterId> data) {
        this.data = Collections.unmodifiableMap(data);
    }

    @Nullable
    public ClusterId get(String database) {
        return this.data.get(database);
    }

    public String toString() {
        return "ClusterIdDirectoryMessage{data=" + this.data + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterIdDirectoryMessage that = (ClusterIdDirectoryMessage)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

