/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import com.neo4j.causalclustering.discovery.akka.coretopology.CleanupMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterViewMessage;
import java.io.Serializable;
import java.time.Duration;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterStateActor
extends AbstractActorWithTimers {
    private final Cluster cluster;
    private final ActorRef topologyActor;
    private final ActorRef downingActor;
    private final Duration clusterStabilityWait;
    private final Log log;
    private ClusterViewMessage clusterView = ClusterViewMessage.EMPTY;
    private static String downingTimerKey = "downingTimerKey key";

    static Props props(Cluster cluster, ActorRef topologyActor, ActorRef downingActor, Config config, LogProvider logProvider) {
        return Props.create(ClusterStateActor.class, (Creator & Serializable)() -> new ClusterStateActor(cluster, topologyActor, downingActor, config, logProvider));
    }

    public ClusterStateActor(Cluster cluster, ActorRef topologyActor, ActorRef downingActor, Config config, LogProvider logProvider) {
        this.cluster = cluster;
        this.topologyActor = topologyActor;
        this.downingActor = downingActor;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.clusterStabilityWait = ((Duration)config.get(CausalClusteringSettings.akka_failure_detector_heartbeat_interval)).plus((Duration)config.get(CausalClusteringSettings.akka_failure_detector_acceptable_heartbeat_pause));
    }

    public void preStart() {
        this.cluster.subscribe(this.getSelf(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.initialStateAsSnapshot(), new Class[]{ClusterEvent.ClusterDomainEvent.class, ClusterEvent.UnreachableMember.class});
    }

    public void postStop() {
        this.cluster.unsubscribe(this.getSelf());
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ClusterEvent.CurrentClusterState.class, this::handleCurrentClusterState).match(ClusterEvent.ReachableMember.class, this::handleReachableMember).match(ClusterEvent.UnreachableMember.class, this::handleUnreachableMember).match(ClusterEvent.MemberUp.class, this::handleMemberUp).match(ClusterEvent.MemberWeaklyUp.class, this::handleMemberWeaklyUp).match(ClusterEvent.MemberRemoved.class, this::handleMemberRemoved).match(ClusterEvent.LeaderChanged.class, this::handleLeaderChanged).match(ClusterEvent.ClusterDomainEvent.class, this::handleOtherClusterEvent).match(StabilityMessage.class, this::notifyDowningActor).build();
    }

    private void handleCurrentClusterState(ClusterEvent.CurrentClusterState event) {
        this.clusterView = new ClusterViewMessage(event);
        this.log.debug("Akka initial cluster state %s", new Object[]{event});
        this.sendClusterView();
    }

    private void handleReachableMember(ClusterEvent.ReachableMember event) {
        this.log.debug("Akka cluster event %s", new Object[]{event});
        this.clusterView = this.clusterView.withoutUnreachable(event.member());
        this.sendClusterView();
    }

    private void handleUnreachableMember(ClusterEvent.UnreachableMember event) {
        this.log.debug("Akka cluster event %s", new Object[]{event});
        this.clusterView = this.clusterView.withUnreachable(event.member());
        this.sendClusterView();
    }

    private void handleMemberUp(ClusterEvent.MemberUp event) {
        this.log.debug("Akka cluster event %s", new Object[]{event});
        this.clusterView = this.clusterView.withMember(event.member());
        this.sendClusterView();
    }

    private void handleMemberWeaklyUp(ClusterEvent.MemberWeaklyUp event) {
        this.log.debug("Akka cluster event %s", new Object[]{event});
        this.clusterView = this.clusterView.withMember(event.member());
        this.sendClusterView();
    }

    private void handleMemberRemoved(ClusterEvent.MemberRemoved event) {
        this.log.debug("Akka cluster event %s", new Object[]{event});
        Member member = event.member();
        this.clusterView = this.clusterView.withoutMember(member);
        this.sendClusterView();
        this.topologyActor.tell((Object)new CleanupMessage(member.uniqueAddress()), this.getSelf());
    }

    private void handleLeaderChanged(ClusterEvent.LeaderChanged event) {
        this.log.debug("Akka cluster event %s", new Object[]{event});
        this.clusterView = this.clusterView.withConverged(event.leader().isDefined());
        this.sendClusterView();
    }

    private void handleOtherClusterEvent(ClusterEvent.ClusterDomainEvent event) {
        this.log.debug("Ignoring Akka cluster event %s", new Object[]{event});
        this.resetDowningTimer();
    }

    private void notifyDowningActor(StabilityMessage ignored) {
        this.log.debug("Cluster is stable at %s", new Object[]{this.clusterView});
        this.downingActor.tell((Object)this.clusterView, this.getSelf());
    }

    private void sendClusterView() {
        this.topologyActor.tell((Object)this.clusterView, this.getSelf());
        this.resetDowningTimer();
    }

    private void resetDowningTimer() {
        this.timers().startSingleTimer((Object)downingTimerKey, (Object)StabilityMessage.INSTANCE, this.clusterStabilityWait);
    }

    private static class StabilityMessage {
        static StabilityMessage INSTANCE = new StabilityMessage();

        private StabilityMessage() {
        }
    }
}

