/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.cluster.UniqueAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.util.VisibleForTesting;

public class ClusterViewMessage {
    private final boolean converged;
    private final SortedSet<Member> members;
    private final Set<Member> unreachable;
    public static final ClusterViewMessage EMPTY = new ClusterViewMessage();

    private ClusterViewMessage() {
        this(false, Collections.unmodifiableSortedSet(new TreeSet(Member.ordering())), Collections.unmodifiableSet(new HashSet()));
    }

    public ClusterViewMessage(ClusterEvent.CurrentClusterState clusterState) {
        this(clusterState.leader().isDefined(), ClusterViewMessage.membersFrom(clusterState), clusterState.getUnreachable());
    }

    private static SortedSet<Member> membersFrom(ClusterEvent.CurrentClusterState clusterState) {
        TreeSet<Member> tempMembers = new TreeSet<Member>((Comparator<Member>)Member.ordering());
        clusterState.getMembers().forEach(tempMembers::add);
        return tempMembers;
    }

    @VisibleForTesting
    ClusterViewMessage(boolean converged, SortedSet<Member> members, Set<Member> unreachable) {
        this.converged = converged;
        TreeSet upMembers = members.stream().filter(this::memberIsUp).collect(Collectors.toCollection(() -> new TreeSet(Member.ordering())));
        this.members = Collections.unmodifiableSortedSet(upMembers);
        this.unreachable = Collections.unmodifiableSet(unreachable);
    }

    public boolean converged() {
        return this.converged;
    }

    public ClusterViewMessage withConverged(boolean converged) {
        return new ClusterViewMessage(converged, this.members, this.unreachable);
    }

    @VisibleForTesting
    public SortedSet<Member> members() {
        return this.members;
    }

    public ClusterViewMessage withMember(Member member) {
        TreeSet<Member> tempMembers = new TreeSet<Member>((Comparator<Member>)Member.ordering());
        tempMembers.addAll(this.members);
        tempMembers.remove(member);
        tempMembers.add(member);
        HashSet<Member> tempUnreachable = new HashSet<Member>(this.unreachable);
        if (tempUnreachable.remove(member)) {
            tempUnreachable.add(member);
        }
        return new ClusterViewMessage(this.converged, tempMembers, tempUnreachable);
    }

    public ClusterViewMessage withoutMember(Member member) {
        TreeSet<Member> tempMembers = new TreeSet<Member>((Comparator<Member>)Member.ordering());
        tempMembers.addAll(this.members);
        tempMembers.remove(member);
        HashSet<Member> tempUnreachable = new HashSet<Member>(this.unreachable);
        tempUnreachable.remove(member);
        return new ClusterViewMessage(this.converged, tempMembers, tempUnreachable);
    }

    public ClusterViewMessage withUnreachable(Member member) {
        HashSet<Member> tempUnreachable = new HashSet<Member>(this.unreachable);
        tempUnreachable.add(member);
        return new ClusterViewMessage(this.converged, this.members, tempUnreachable);
    }

    public ClusterViewMessage withoutUnreachable(Member member) {
        HashSet<Member> tempUnreachable = new HashSet<Member>(this.unreachable);
        tempUnreachable.remove(member);
        return new ClusterViewMessage(this.converged, this.members, tempUnreachable);
    }

    public Stream<UniqueAddress> availableMembers() {
        return this.members.stream().filter(member -> !this.unreachable.contains(member)).map(Member::uniqueAddress);
    }

    public Set<Member> unreachable() {
        return this.unreachable;
    }

    public boolean mostAreReachable() {
        int unreachableSize = this.unreachable.size();
        int reachableSize = this.members.size() - unreachableSize;
        return reachableSize > unreachableSize;
    }

    private boolean memberIsUp(Member m) {
        return MemberStatus.up().equals(m.status()) || MemberStatus.weaklyUp().equals(m.status());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterViewMessage that = (ClusterViewMessage)o;
        return this.converged == that.converged && Objects.equals(this.members, that.members) && Objects.equals(this.unreachable, that.unreachable);
    }

    public int hashCode() {
        return Objects.hash(this.converged, this.members, this.unreachable);
    }

    public String toString() {
        return "ClusterViewMessage{converged=" + this.converged + ", members=" + this.members + ", unreachable=" + this.unreachable + '}';
    }
}

