/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.Member;
import akka.japi.Creator;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterDowningActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterIdActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterIdDirectoryMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterIdSettingMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterStateActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterViewMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.CoreTopologyMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.MetadataActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.MetadataMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.TopologyBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CoreTopologyActor
extends AbstractActorWithTimers {
    public static final String NAME = "cc-core-topology-actor";
    private final SourceQueueWithComplete<CoreTopologyMessage> topologyUpdateSink;
    private final TopologyBuilder topologyBuilder;
    private final String databaseName;
    private final Address myAddress;
    private final Log log;
    private final ActorRef clusterIdActor;
    private final ActorRef readReplicaTopologyActor;
    private MetadataMessage memberData;
    private ClusterIdDirectoryMessage clusterIdPerDb;
    private ClusterViewMessage clusterView;
    private CoreTopology coreTopology;

    public static Props props(MemberId myself, SourceQueueWithComplete<CoreTopologyMessage> topologyUpdateSink, ActorRef rrTopologyActor, ActorRef replicator, Cluster cluster, TopologyBuilder topologyBuilder, Config config, LogProvider logProvider) {
        return Props.create(CoreTopologyActor.class, (Creator & Serializable)() -> new CoreTopologyActor(myself, topologyUpdateSink, rrTopologyActor, replicator, cluster, topologyBuilder, config, logProvider));
    }

    CoreTopologyActor(MemberId myself, SourceQueueWithComplete<CoreTopologyMessage> topologyUpdateSink, ActorRef readReplicaTopologyActor, ActorRef replicator, Cluster cluster, TopologyBuilder topologyBuilder, Config config, LogProvider logProvider) {
        this.topologyUpdateSink = topologyUpdateSink;
        this.readReplicaTopologyActor = readReplicaTopologyActor;
        this.topologyBuilder = topologyBuilder;
        this.memberData = MetadataMessage.EMPTY;
        this.clusterIdPerDb = ClusterIdDirectoryMessage.EMPTY;
        this.databaseName = (String)config.get(CausalClusteringSettings.database);
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.clusterView = ClusterViewMessage.EMPTY;
        this.coreTopology = CoreTopology.EMPTY;
        this.myAddress = cluster.selfAddress();
        ActorRef metadataActor = this.getContext().actorOf(MetadataActor.props(myself, cluster, replicator, this.getSelf(), config, logProvider));
        ActorRef downingActor = this.getContext().actorOf(ClusterDowningActor.props(cluster, metadataActor, logProvider));
        this.getContext().actorOf(ClusterStateActor.props(cluster, this.getSelf(), downingActor, config, logProvider));
        this.clusterIdActor = this.getContext().actorOf(ClusterIdActor.props(cluster, replicator, this.getSelf(), logProvider));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ClusterViewMessage.class, this::handleClusterViewMessage).match(MetadataMessage.class, this::handleMetadataMessage).match(ClusterIdDirectoryMessage.class, this::handleClusterIdDirectoryMessage).match(ClusterIdSettingMessage.class, this::handleClusterIdSettingMessage).build();
    }

    private void handleClusterViewMessage(ClusterViewMessage message) {
        this.clusterView = message;
        this.buildTopology();
    }

    private void handleMetadataMessage(MetadataMessage message) {
        this.memberData = message;
        this.buildTopology();
    }

    private void handleClusterIdDirectoryMessage(ClusterIdDirectoryMessage message) {
        this.clusterIdPerDb = message;
        this.buildTopology();
    }

    private void handleClusterIdSettingMessage(ClusterIdSettingMessage message) {
        this.clusterIdActor.forward((Object)message, this.context());
    }

    private void buildTopology() {
        CoreTopology newCoreTopology = this.topologyBuilder.buildCoreTopology(this.clusterIdPerDb.get(this.databaseName), this.clusterView, this.memberData);
        if (!this.coreTopology.equals((Object)newCoreTopology) || !Objects.equals(this.coreTopology.clusterId(), newCoreTopology.clusterId())) {
            this.coreTopology = newCoreTopology;
            Collection akkaMemberAddresses = this.clusterView.members().stream().map(Member::address).filter(addr -> !addr.equals((Object)this.myAddress)).collect(Collectors.toList());
            this.topologyUpdateSink.offer((Object)new CoreTopologyMessage(newCoreTopology, akkaMemberAddresses));
            this.readReplicaTopologyActor.tell((Object)newCoreTopology, this.getSelf());
        }
    }
}

