/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.UniqueAddress;
import akka.cluster.ddata.LWWMap;
import akka.cluster.ddata.LWWMapKey;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import com.neo4j.causalclustering.discovery.akka.BaseReplicatedDataActor;
import com.neo4j.causalclustering.discovery.akka.coretopology.CleanupMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.CoreServerInfoForMemberId;
import com.neo4j.causalclustering.discovery.akka.coretopology.MetadataMessage;
import java.io.Serializable;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

public class MetadataActor
extends BaseReplicatedDataActor<LWWMap<UniqueAddress, CoreServerInfoForMemberId>> {
    static final String MEMBER_DATA_KEY = "member-data";
    private final MemberId myself;
    private final ActorRef topologyActor;
    private final Config config;

    static Props props(MemberId myself, Cluster cluster, ActorRef replicator, ActorRef topologyActor, Config config, LogProvider logProvider) {
        return Props.create(MetadataActor.class, (Creator & Serializable)() -> new MetadataActor(myself, cluster, replicator, topologyActor, config, logProvider));
    }

    public MetadataActor(MemberId myself, Cluster cluster, ActorRef replicator, ActorRef topologyActor, Config config, LogProvider logProvider) {
        super(cluster, replicator, LWWMapKey.create((String)MEMBER_DATA_KEY), LWWMap::empty, logProvider);
        this.myself = myself;
        this.topologyActor = topologyActor;
        this.config = config;
    }

    @Override
    protected void handleCustomEvents(ReceiveBuilder builder) {
        builder.match(CleanupMessage.class, message -> this.removeDataFromReplicator(message.uniqueAddress()));
    }

    @Override
    public void sendInitialDataToReplicator() {
        CoreServerInfoForMemberId metadata = new CoreServerInfoForMemberId(this.myself, CoreServerInfo.from((Config)this.config));
        this.modifyReplicatedData(this.key, map -> map.put(this.cluster, (Object)this.cluster.selfUniqueAddress(), (Object)metadata));
    }

    @Override
    public void removeDataFromReplicator(UniqueAddress uniqueAddress) {
        this.modifyReplicatedData(this.key, map -> map.remove(this.cluster, (Object)uniqueAddress));
    }

    @Override
    protected void handleIncomingData(LWWMap<UniqueAddress, CoreServerInfoForMemberId> delta) {
        this.data = ((LWWMap)this.data).merge(delta);
        this.topologyActor.tell((Object)new MetadataMessage((LWWMap<UniqueAddress, CoreServerInfoForMemberId>)((LWWMap)this.data)), this.getSelf());
    }
}

