/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.event.EventStream;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import akka.remote.ThisActorSystemQuarantinedEvent;
import java.io.Serializable;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RestartNeededListeningActor
extends AbstractActor {
    public static String NAME = "cc-core-restart-needed-listener";
    private final Runnable restart;
    private final EventStream eventStream;
    private final Cluster cluster;
    private final Log log;

    public static Props props(Runnable restart, EventStream eventStream, Cluster cluster, LogProvider logProvider) {
        return Props.create(RestartNeededListeningActor.class, (Creator & Serializable)() -> new RestartNeededListeningActor(restart, eventStream, cluster, logProvider));
    }

    private RestartNeededListeningActor(Runnable restart, EventStream eventStream, Cluster cluster, LogProvider logProvider) {
        this.restart = restart;
        this.eventStream = eventStream;
        this.cluster = cluster;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void preStart() {
        this.eventStream.subscribe(this.getSelf(), ThisActorSystemQuarantinedEvent.class);
        this.cluster.subscribe(this.getSelf(), new Class[]{ClusterEvent.ClusterShuttingDown$.class});
    }

    public void postStop() {
        this.unsubscribe();
    }

    private void unsubscribe() {
        this.eventStream.unsubscribe(this.getSelf(), ThisActorSystemQuarantinedEvent.class);
        this.cluster.unsubscribe(this.getSelf(), ClusterEvent.ClusterShuttingDown$.class);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ThisActorSystemQuarantinedEvent.class, this::doRestart).match(ClusterEvent.ClusterShuttingDown$.class, this::doRestart).match(ClusterEvent.CurrentClusterState.class, ignore -> {}).build();
    }

    private void doRestart(Object event) {
        this.log.info("Restart triggered by %s ", new Object[]{event});
        this.restart.run();
        this.unsubscribe();
        this.getContext().become(this.createShuttingDownReceive());
    }

    private AbstractActor.Receive createShuttingDownReceive() {
        return ReceiveBuilder.create().match(ThisActorSystemQuarantinedEvent.class, this::ignore).match(ClusterEvent.ClusterShuttingDown$.class, this::ignore).match(ClusterEvent.CurrentClusterState.class, ignore -> {}).build();
    }

    private void ignore(Object event) {
        this.log.debug("Ignoring as restart has been triggered: %s", new Object[]{event});
    }
}

