/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.coretopology;

import akka.cluster.UniqueAddress;
import com.neo4j.causalclustering.discovery.akka.coretopology.ClusterViewMessage;
import com.neo4j.causalclustering.discovery.akka.coretopology.CoreServerInfoForMemberId;
import com.neo4j.causalclustering.discovery.akka.coretopology.MetadataMessage;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class TopologyBuilder {
    private final Config config;
    private final Log log;
    private final UniqueAddress uniqueAddress;

    public TopologyBuilder(Config config, UniqueAddress uniqueAddress, LogProvider logProvider) {
        this.config = config;
        this.uniqueAddress = uniqueAddress;
        this.log = logProvider.getLog(this.getClass());
    }

    CoreTopology buildCoreTopology(@Nullable ClusterId clusterId, ClusterViewMessage cluster, MetadataMessage memberData) {
        this.log.debug("Building new view of Topology from actor %s, cluster state is: %s, metadata is %s", new Object[]{this.uniqueAddress, cluster, memberData});
        Map<MemberId, CoreServerInfo> coreMembers = this.getCoreInfos(cluster, memberData).collect(Collectors.toMap(CoreServerInfoForMemberId::memberId, CoreServerInfoForMemberId::coreServerInfo));
        boolean canBeBootstrapped = this.canBeBootstrapped(cluster, memberData);
        CoreTopology newCoreTopology = new CoreTopology(clusterId, canBeBootstrapped, coreMembers);
        this.log.debug("Returned topology: %s", new Object[]{newCoreTopology});
        return newCoreTopology;
    }

    private Stream<CoreServerInfoForMemberId> getCoreInfos(ClusterViewMessage cluster, MetadataMessage memberData) {
        return cluster.availableMembers().flatMap(memberData::getStream);
    }

    private boolean canBeBootstrapped(ClusterViewMessage cluster, MetadataMessage memberData) {
        boolean iDoNotRefuseToBeLeader = (Boolean)this.config.get(CausalClusteringSettings.refuse_to_be_leader) == false;
        boolean clusterHasConverged = cluster.converged();
        String dbName = (String)this.config.get(CausalClusteringSettings.database);
        boolean iAmFirstPotentialLeader = this.iAmFirstPotentialLeader(cluster, memberData, dbName);
        return iDoNotRefuseToBeLeader && clusterHasConverged && iAmFirstPotentialLeader;
    }

    private Boolean iAmFirstPotentialLeader(ClusterViewMessage cluster, MetadataMessage memberData, String dbName) {
        Optional<UniqueAddress> firstPotentialLeader = cluster.availableMembers().filter(member -> this.potentialLeaderForDatabase((UniqueAddress)member, memberData, dbName)).findFirst();
        return firstPotentialLeader.map(first -> first.equals((Object)this.uniqueAddress)).orElse(false);
    }

    private boolean potentialLeaderForDatabase(UniqueAddress member, MetadataMessage memberData, String dbName) {
        return memberData.getOpt(member).map(metadata -> {
            CoreServerInfo c = metadata.coreServerInfo();
            return !c.refusesToBeLeader() && c.getDatabaseName().equals(dbName);
        }).orElse(false);
    }
}

