/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.directory;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.UniqueAddress;
import akka.cluster.ddata.ORMap;
import akka.cluster.ddata.ORMapKey;
import akka.cluster.ddata.ReplicatedData;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.neo4j.causalclustering.discovery.akka.BaseReplicatedDataActor;
import com.neo4j.causalclustering.discovery.akka.directory.LeaderInfoDirectoryMessage;
import com.neo4j.causalclustering.discovery.akka.directory.LeaderInfoSettingMessage;
import com.neo4j.causalclustering.discovery.akka.directory.ReplicatedLeaderInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.logging.LogProvider;

public class DirectoryActor
extends BaseReplicatedDataActor<ORMap<String, ReplicatedLeaderInfo>> {
    static final String PER_DB_LEADER_KEY = "per-db-leader-name";
    public static final String NAME = "cc-directory-actor";
    private final SourceQueueWithComplete<Map<String, LeaderInfo>> discoveryUpdateSink;
    private final ActorRef rrTopologyActor;

    public static Props props(Cluster cluster, ActorRef replicator, SourceQueueWithComplete<Map<String, LeaderInfo>> discoveryUpdateSink, ActorRef rrTopologyActor, LogProvider logProvider) {
        return Props.create(DirectoryActor.class, (Creator & Serializable)() -> new DirectoryActor(cluster, replicator, discoveryUpdateSink, rrTopologyActor, logProvider));
    }

    protected DirectoryActor(Cluster cluster, ActorRef replicator, SourceQueueWithComplete<Map<String, LeaderInfo>> discoveryUpdateSink, ActorRef rrTopologyActor, LogProvider logProvider) {
        super(cluster, replicator, ORMapKey.create((String)PER_DB_LEADER_KEY), ORMap::create, logProvider);
        this.discoveryUpdateSink = discoveryUpdateSink;
        this.rrTopologyActor = rrTopologyActor;
    }

    @Override
    protected void sendInitialDataToReplicator() {
    }

    @Override
    protected void removeDataFromReplicator(UniqueAddress uniqueAddress) {
    }

    @Override
    protected void handleCustomEvents(ReceiveBuilder builder) {
        builder.match(LeaderInfoSettingMessage.class, message -> this.modifyReplicatedData(this.key, map -> map.put(this.cluster, (Object)message.database(), (ReplicatedData)new ReplicatedLeaderInfo(message.leaderInfo()))));
    }

    @Override
    protected void handleIncomingData(ORMap<String, ReplicatedLeaderInfo> newData) {
        this.data = ((ORMap)this.data).merge(newData);
        Map<String, LeaderInfo> leaderInfos = ((ORMap)this.data).getEntries().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ReplicatedLeaderInfo)((Object)((Object)e.getValue()))).leaderInfo()));
        this.discoveryUpdateSink.offer(leaderInfos);
        this.rrTopologyActor.tell((Object)new LeaderInfoDirectoryMessage(leaderInfos), this.getSelf());
    }
}

