/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.marshal;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.Serialization;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ActorRefMarshal
extends SafeChannelMarshal<ActorRef> {
    private final ExtendedActorSystem actorSystem;

    public ActorRefMarshal(ExtendedActorSystem actorSystem) {
        this.actorSystem = actorSystem;
    }

    protected ActorRef unmarshal0(ReadableChannel channel) throws IOException {
        String actorRefPath = StringMarshal.unmarshal((ReadableChannel)channel);
        return this.actorSystem.provider().resolveActorRef(actorRefPath);
    }

    public void marshal(ActorRef actorRef, WritableChannel channel) throws IOException {
        String actorPath = Serialization.serializedActorPath((ActorRef)actorRef);
        StringMarshal.marshal((WritableChannel)channel, (String)actorPath);
    }
}

