/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.marshal;

import com.neo4j.causalclustering.discovery.akka.marshal.AdvertisedSocketAddressMarshal;
import java.io.IOException;
import java.util.HashSet;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.BooleanMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreServerInfoMarshal
extends SafeChannelMarshal<CoreServerInfo> {
    private final ChannelMarshal<ClientConnectorAddresses> clientConnectorAddressesMarshal = new ClientConnectorAddresses.Marshal();
    private final ChannelMarshal<AdvertisedSocketAddress> advertisedSocketAddressMarshal = new AdvertisedSocketAddressMarshal();

    protected CoreServerInfo unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        AdvertisedSocketAddress raftServer = (AdvertisedSocketAddress)this.advertisedSocketAddressMarshal.unmarshal(channel);
        AdvertisedSocketAddress catchupServer = (AdvertisedSocketAddress)this.advertisedSocketAddressMarshal.unmarshal(channel);
        ClientConnectorAddresses clientConnectorAddresses = (ClientConnectorAddresses)this.clientConnectorAddressesMarshal.unmarshal(channel);
        int groupsSize = channel.getInt();
        HashSet<String> groups = new HashSet<String>(groupsSize);
        for (int i = 0; i < groupsSize; ++i) {
            groups.add(StringMarshal.unmarshal((ReadableChannel)channel));
        }
        String databaseName = StringMarshal.unmarshal((ReadableChannel)channel);
        boolean refuseToBeLeader = BooleanMarshal.unmarshal((ReadableChannel)channel);
        return new CoreServerInfo(raftServer, catchupServer, clientConnectorAddresses, groups, databaseName, refuseToBeLeader);
    }

    public void marshal(CoreServerInfo coreServerInfo, WritableChannel channel) throws IOException {
        this.advertisedSocketAddressMarshal.marshal((Object)coreServerInfo.getRaftServer(), channel);
        this.advertisedSocketAddressMarshal.marshal((Object)coreServerInfo.getCatchupServer(), channel);
        this.clientConnectorAddressesMarshal.marshal((Object)coreServerInfo.connectors(), channel);
        channel.putInt(coreServerInfo.groups().size());
        for (String group : coreServerInfo.groups()) {
            StringMarshal.marshal((WritableChannel)channel, (String)group);
        }
        StringMarshal.marshal((WritableChannel)channel, (String)coreServerInfo.getDatabaseName());
        BooleanMarshal.marshal((WritableChannel)channel, (boolean)coreServerInfo.refusesToBeLeader());
    }
}

