/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.marshal;

import com.neo4j.causalclustering.discovery.akka.marshal.CoreServerInfoMarshal;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.BooleanMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreTopologyMarshal
extends SafeChannelMarshal<CoreTopology> {
    private final ChannelMarshal<MemberId> memberIdMarshal = new MemberId.Marshal();
    private final ChannelMarshal<CoreServerInfo> coreServerInfoChannelMarshal = new CoreServerInfoMarshal();
    private final ChannelMarshal<ClusterId> clusterIdMarshal = new ClusterId.Marshal();

    protected CoreTopology unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        ClusterId clusterId = (ClusterId)this.clusterIdMarshal.unmarshal(channel);
        boolean canBeBootstrapped = BooleanMarshal.unmarshal((ReadableChannel)channel);
        int memberCount = channel.getInt();
        HashMap<MemberId, CoreServerInfo> members = new HashMap<MemberId, CoreServerInfo>(memberCount);
        for (int i = 0; i < memberCount; ++i) {
            MemberId memberId = (MemberId)this.memberIdMarshal.unmarshal(channel);
            CoreServerInfo coreServerInfo = (CoreServerInfo)this.coreServerInfoChannelMarshal.unmarshal(channel);
            members.put(memberId, coreServerInfo);
        }
        return new CoreTopology(clusterId, canBeBootstrapped, members);
    }

    public void marshal(CoreTopology coreTopology, WritableChannel channel) throws IOException {
        this.clusterIdMarshal.marshal((Object)coreTopology.clusterId(), channel);
        BooleanMarshal.marshal((WritableChannel)channel, (boolean)coreTopology.canBeBootstrapped());
        channel.putInt(coreTopology.members().size());
        for (Map.Entry entry : coreTopology.members().entrySet()) {
            this.memberIdMarshal.marshal(entry.getKey(), channel);
            this.coreServerInfoChannelMarshal.marshal(entry.getValue(), channel);
        }
    }
}

