/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.marshal;

import com.neo4j.causalclustering.discovery.akka.directory.LeaderInfoDirectoryMessage;
import com.neo4j.causalclustering.discovery.akka.marshal.LeaderInfoMarshal;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class DatabaseLeaderInfoMessageMarshal
extends SafeChannelMarshal<LeaderInfoDirectoryMessage> {
    private final ChannelMarshal<LeaderInfo> leaderInfoMarshal = new LeaderInfoMarshal();

    protected LeaderInfoDirectoryMessage unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        int size = channel.getInt();
        HashMap<String, LeaderInfo> leaders = new HashMap<String, LeaderInfo>(size);
        for (int i = 0; i < size; ++i) {
            String database = StringMarshal.unmarshal((ReadableChannel)channel);
            LeaderInfo leaderInfo = (LeaderInfo)this.leaderInfoMarshal.unmarshal(channel);
            leaders.put(database, leaderInfo);
        }
        return new LeaderInfoDirectoryMessage(leaders);
    }

    public void marshal(LeaderInfoDirectoryMessage leaderInfoDirectoryMessage, WritableChannel channel) throws IOException {
        channel.putInt(leaderInfoDirectoryMessage.leaders().size());
        for (Map.Entry<String, LeaderInfo> entry : leaderInfoDirectoryMessage.leaders().entrySet()) {
            String database = entry.getKey();
            LeaderInfo leaderInfo = entry.getValue();
            StringMarshal.marshal((WritableChannel)channel, (String)database);
            this.leaderInfoMarshal.marshal((Object)leaderInfo, channel);
        }
    }
}

