/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.marshal;

import com.neo4j.causalclustering.discovery.akka.marshal.AdvertisedSocketAddressMarshal;
import java.io.IOException;
import java.util.HashSet;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ReadReplicaInfoMarshal
extends SafeChannelMarshal<ReadReplicaInfo> {
    private final ChannelMarshal<ClientConnectorAddresses> clientConnectorAddressesMarshal = new ClientConnectorAddresses.Marshal();
    private final ChannelMarshal<AdvertisedSocketAddress> advertisedSocketAddressMarshal = new AdvertisedSocketAddressMarshal();

    protected ReadReplicaInfo unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        ClientConnectorAddresses clientConnectorAddresses = (ClientConnectorAddresses)this.clientConnectorAddressesMarshal.unmarshal(channel);
        AdvertisedSocketAddress catchupServer = (AdvertisedSocketAddress)this.advertisedSocketAddressMarshal.unmarshal(channel);
        int groupsSize = channel.getInt();
        HashSet<String> groups = new HashSet<String>(groupsSize);
        for (int i = 0; i < groupsSize; ++i) {
            groups.add(StringMarshal.unmarshal((ReadableChannel)channel));
        }
        String databaseName = StringMarshal.unmarshal((ReadableChannel)channel);
        return new ReadReplicaInfo(clientConnectorAddresses, catchupServer, groups, databaseName);
    }

    public void marshal(ReadReplicaInfo readReplicaInfo, WritableChannel channel) throws IOException {
        this.clientConnectorAddressesMarshal.marshal((Object)readReplicaInfo.connectors(), channel);
        this.advertisedSocketAddressMarshal.marshal((Object)readReplicaInfo.getCatchupServer(), channel);
        channel.putInt(readReplicaInfo.groups().size());
        for (String group : readReplicaInfo.groups()) {
            StringMarshal.marshal((WritableChannel)channel, (String)group);
        }
        StringMarshal.marshal((WritableChannel)channel, (String)readReplicaInfo.getDatabaseName());
    }
}

