/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.marshal;

import com.neo4j.causalclustering.discovery.akka.marshal.ReadReplicaInfoMarshal;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ReadReplicaTopologyMarshal
extends SafeChannelMarshal<ReadReplicaTopology> {
    private final ChannelMarshal<ReadReplicaInfo> readReplicaInfoMarshal = new ReadReplicaInfoMarshal();
    private final ChannelMarshal<MemberId> memberIdMarshal = new MemberId.Marshal();

    protected ReadReplicaTopology unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        int size = channel.getInt();
        HashMap<MemberId, ReadReplicaInfo> replicas = new HashMap<MemberId, ReadReplicaInfo>(size);
        for (int i = 0; i < size; ++i) {
            MemberId memberId = (MemberId)this.memberIdMarshal.unmarshal(channel);
            ReadReplicaInfo readReplicaInfo = (ReadReplicaInfo)this.readReplicaInfoMarshal.unmarshal(channel);
            replicas.put(memberId, readReplicaInfo);
        }
        return new ReadReplicaTopology(replicas);
    }

    public void marshal(ReadReplicaTopology readReplicaTopology, WritableChannel channel) throws IOException {
        channel.putInt(readReplicaTopology.members().size());
        for (Map.Entry entry : readReplicaTopology.members().entrySet()) {
            MemberId memberId = (MemberId)entry.getKey();
            ReadReplicaInfo readReplicaInfo = (ReadReplicaInfo)entry.getValue();
            this.memberIdMarshal.marshal((Object)memberId, channel);
            this.readReplicaInfoMarshal.marshal((Object)readReplicaInfo, channel);
        }
    }
}

