/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.marshal;

import akka.actor.Address;
import akka.cluster.UniqueAddress;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import scala.Int;

public class UniqueAddressMarshal
extends SafeChannelMarshal<UniqueAddress> {
    protected UniqueAddress unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        String protocol = StringMarshal.unmarshal((ReadableChannel)channel);
        String system = StringMarshal.unmarshal((ReadableChannel)channel);
        String host = StringMarshal.unmarshal((ReadableChannel)channel);
        int port = channel.getInt();
        long uid = channel.getLong();
        Address address = host != null ? new Address(protocol, system, host, port) : new Address(protocol, system);
        return new UniqueAddress(address, uid);
    }

    public void marshal(UniqueAddress uniqueAddress, WritableChannel channel) throws IOException {
        Address address = uniqueAddress.address();
        StringMarshal.marshal((WritableChannel)channel, (String)address.protocol());
        StringMarshal.marshal((WritableChannel)channel, (String)address.system());
        if (address.host().isDefined()) {
            StringMarshal.marshal((WritableChannel)channel, (String)((String)address.host().get()));
        } else {
            StringMarshal.marshal((WritableChannel)channel, null);
        }
        if (address.port().isDefined()) {
            channel.putInt(Int.unbox((Object)address.port().get()));
        } else {
            channel.putInt(-1);
        }
        channel.putLong(uniqueAddress.longUid());
    }
}

