/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.readreplicatopology;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.client.ClusterClient;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.neo4j.causalclustering.discovery.akka.directory.LeaderInfoDirectoryMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaRefreshMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaRemovalMessage;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClientTopologyActor
extends AbstractActorWithTimers {
    private static final String REFRESH = "topology refresh";
    public static final String NAME = "cc-client-topology-actor";
    private final Duration refresh;
    private final MemberId myself;
    private final ReadReplicaInfo readReplicaInfo;
    private final SourceQueueWithComplete<CoreTopology> coreTopologySink;
    private final SourceQueueWithComplete<ReadReplicaTopology> rrTopologySink;
    private final SourceQueueWithComplete<Map<String, LeaderInfo>> discoverySink;
    private final ActorRef clusterClient;
    private final Log log;

    public static Props props(MemberId myself, SourceQueueWithComplete<CoreTopology> coreTopologySink, SourceQueueWithComplete<ReadReplicaTopology> rrTopologySink, SourceQueueWithComplete<Map<String, LeaderInfo>> discoverySink, ActorRef clusterClient, Config config, LogProvider logProvider) {
        return Props.create(ClientTopologyActor.class, (Creator & Serializable)() -> new ClientTopologyActor(myself, coreTopologySink, rrTopologySink, discoverySink, clusterClient, config, logProvider));
    }

    ClientTopologyActor(MemberId myself, SourceQueueWithComplete<CoreTopology> coreTopologySink, SourceQueueWithComplete<ReadReplicaTopology> rrTopologySink, SourceQueueWithComplete<Map<String, LeaderInfo>> discoverySink, ActorRef clusterClient, Config config, LogProvider logProvider) {
        this.myself = myself;
        this.coreTopologySink = coreTopologySink;
        this.rrTopologySink = rrTopologySink;
        this.discoverySink = discoverySink;
        this.clusterClient = clusterClient;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.readReplicaInfo = ReadReplicaInfo.from((Config)config);
        this.refresh = (Duration)config.get(CausalClusteringSettings.cluster_topology_refresh);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(CoreTopology.class, arg_0 -> this.coreTopologySink.offer(arg_0)).match(ReadReplicaTopology.class, arg_0 -> this.rrTopologySink.offer(arg_0)).match(LeaderInfoDirectoryMessage.class, msg -> this.discoverySink.offer(msg.leaders())).match(Refresh.class, ignored -> this.sendInfo()).build();
    }

    public void preStart() {
        this.getTimers().startPeriodicTimer((Object)REFRESH, (Object)Refresh.instance, this.refresh);
        this.sendInfo();
    }

    private void sendInfo() {
        ReadReplicaRefreshMessage msg = new ReadReplicaRefreshMessage(this.readReplicaInfo, this.myself, this.clusterClient, this.getSelf());
        this.sendToCore(msg);
    }

    public void postStop() {
        ReadReplicaRemovalMessage msg = new ReadReplicaRemovalMessage(this.clusterClient);
        this.log.debug("Shutting down and sending removal message: %s", new Object[]{msg});
        this.sendToCore(msg);
    }

    private void sendToCore(Object msg) {
        this.clusterClient.tell((Object)new ClusterClient.Publish("rr-topic", msg), this.getSelf());
    }

    private static final class Refresh {
        private static final Refresh instance = new Refresh();

        private Refresh() {
        }

        public static Refresh getInstance() {
            return instance;
        }
    }
}

