/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.readreplicatopology;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.client.ClusterClientUnreachable;
import akka.cluster.client.ClusterClientUp;
import akka.cluster.client.ClusterClients;
import akka.cluster.client.SubscribeClusterClients;
import akka.cluster.client.UnsubscribeClusterClients;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ClusterClientViewMessage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class ClusterClientViewActor
extends AbstractActor {
    private final Log log;
    private final ActorRef parent;
    private final ActorRef receptionist;
    private Set<ActorRef> clusterClients = new HashSet<ActorRef>();

    static Props props(ActorRef parent, ActorRef receptionist, LogProvider logProvider) {
        return Props.create(ClusterClientViewActor.class, (Creator & Serializable)() -> new ClusterClientViewActor(parent, receptionist, logProvider));
    }

    private ClusterClientViewActor(ActorRef parent, ActorRef receptionist, LogProvider logProvider) {
        this.parent = parent;
        this.receptionist = receptionist;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void preStart() {
        this.receptionist.tell((Object)SubscribeClusterClients.getInstance(), this.getSelf());
    }

    public void postStop() {
        this.receptionist.tell((Object)UnsubscribeClusterClients.getInstance(), this.getSelf());
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ClusterClients.class, this::handleClusterClients).match(ClusterClientUp.class, this::handleClusterClientUp).match(ClusterClientUnreachable.class, this::handleClusterClientUnreachable).build();
    }

    private void handleClusterClients(ClusterClients msg) {
        this.log.debug("All cluster clients: %s", new Object[]{msg});
        this.clusterClients.addAll(msg.getClusterClients());
        this.sendToParent();
    }

    private void handleClusterClientUp(ClusterClientUp msg) {
        this.log.debug("Cluster client up: %s", new Object[]{msg});
        this.clusterClients.add(msg.clusterClient());
        this.sendToParent();
    }

    private void handleClusterClientUnreachable(ClusterClientUnreachable msg) {
        this.log.debug("Cluster client down: %s", new Object[]{msg});
        this.clusterClients.remove(msg.clusterClient());
        this.sendToParent();
    }

    private void sendToParent() {
        this.parent.tell((Object)new ClusterClientViewMessage(this.clusterClients), this.getSelf());
    }
}

