/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.readreplicatopology;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.client.ClusterClientReceptionist;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.neo4j.causalclustering.discovery.akka.directory.LeaderInfoDirectoryMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ClusterClientViewActor;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ClusterClientViewMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaViewActor;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaViewMessage;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ReadReplicaTopologyActor
extends AbstractActor {
    private final SourceQueueWithComplete<ReadReplicaTopology> topologySink;
    private final Log log;
    private CoreTopology coreTopology = CoreTopology.EMPTY;
    private LeaderInfoDirectoryMessage databaseLeaderInfo = LeaderInfoDirectoryMessage.EMPTY;
    private ReadReplicaTopology readReplicaTopology = ReadReplicaTopology.EMPTY;
    private Set<ActorRef> myClusterClients = new HashSet<ActorRef>();
    private ReadReplicaViewMessage readReplicaViewMessage = ReadReplicaViewMessage.EMPTY;
    public static final String NAME = "cc-rr-topology-actor";

    public static Props props(SourceQueueWithComplete<ReadReplicaTopology> topologySink, ClusterClientReceptionist receptionist, LogProvider logProvider, Config config, Clock clock) {
        return Props.create(ReadReplicaTopologyActor.class, (Creator & Serializable)() -> new ReadReplicaTopologyActor(topologySink, receptionist, logProvider, config, clock));
    }

    ReadReplicaTopologyActor(SourceQueueWithComplete<ReadReplicaTopology> topologySink, ClusterClientReceptionist receptionist, LogProvider logProvider, Config config, Clock clock) {
        this.topologySink = topologySink;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        Duration refresh = (Duration)config.get(CausalClusteringSettings.cluster_topology_refresh);
        Props readReplicaViewProps = ReadReplicaViewActor.props(this.getSelf(), receptionist, clock, refresh, logProvider);
        this.getContext().actorOf(readReplicaViewProps);
        Props clusterClientViewProps = ClusterClientViewActor.props(this.getSelf(), receptionist.underlying(), logProvider);
        this.getContext().actorOf(clusterClientViewProps);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ClusterClientViewMessage.class, this::handleClusterClientView).match(ReadReplicaViewMessage.class, this::handleReadReplicaView).match(ReadReplicaViewActor.Tick.class, this::sendTopologiesToClients).match(CoreTopology.class, this::setCoreTopology).match(LeaderInfoDirectoryMessage.class, this::setDatabaseLeaderInfo).build();
    }

    private void handleReadReplicaView(ReadReplicaViewMessage msg) {
        this.readReplicaViewMessage = msg;
        this.buildTopology();
    }

    private void handleClusterClientView(ClusterClientViewMessage msg) {
        this.myClusterClients = msg.clusterClients();
        this.buildTopology();
    }

    private Stream<ActorRef> myTopologyClients() {
        return this.myClusterClients.stream().flatMap(this.readReplicaViewMessage::topologyClient);
    }

    private void sendTopologiesToClients(ReadReplicaViewActor.Tick ignored) {
        this.log.debug("Sending to clients: %s, %s, %s", new Object[]{this.readReplicaTopology, this.coreTopology, this.databaseLeaderInfo});
        this.myTopologyClients().forEach(client -> {
            client.tell((Object)this.readReplicaTopology, this.getSelf());
            client.tell((Object)this.coreTopology, this.getSelf());
            client.tell((Object)this.databaseLeaderInfo, this.getSelf());
        });
    }

    private void setCoreTopology(CoreTopology coreTopology) {
        this.coreTopology = coreTopology;
    }

    private void setDatabaseLeaderInfo(LeaderInfoDirectoryMessage leaderInfo) {
        this.databaseLeaderInfo = leaderInfo;
    }

    private void buildTopology() {
        this.log.debug("Building read replica topology with read replicas: %s", new Object[]{this.readReplicaViewMessage});
        ReadReplicaTopology readReplicaTopology = this.readReplicaViewMessage.toReadReplicaTopology();
        this.log.debug("Built read replica topology %s", new Object[]{readReplicaTopology});
        if (!this.readReplicaTopology.equals((Object)readReplicaTopology)) {
            this.topologySink.offer((Object)readReplicaTopology);
            this.readReplicaTopology = readReplicaTopology;
        }
    }
}

