/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.readreplicatopology;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.cluster.client.ClusterClientReceptionist;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaRefreshMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaRemovalMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaViewMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaViewRecord;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class ReadReplicaViewActor
extends AbstractActorWithTimers {
    static final String READ_REPLICA_TOPIC = "rr-topic";
    static final int TICKS_BEFORE_REMOVE_READ_REPLICA = 3;
    private static final String TICK_KEY = "Tick key";
    private final ActorRef parent;
    private final ClusterClientReceptionist receptionist;
    private final Clock clock;
    private final Duration refresh;
    private final Log log;
    private Map<ActorRef, ReadReplicaViewRecord> clusterClientReadReplicas = new HashMap<ActorRef, ReadReplicaViewRecord>();

    static Props props(ActorRef parent, ClusterClientReceptionist receptionist, Clock clock, Duration refresh, LogProvider logProvider) {
        return Props.create(ReadReplicaViewActor.class, (Creator & Serializable)() -> new ReadReplicaViewActor(parent, receptionist, clock, refresh, logProvider));
    }

    private ReadReplicaViewActor(ActorRef parent, ClusterClientReceptionist receptionist, Clock clock, Duration refresh, LogProvider logProvider) {
        this.parent = parent;
        this.receptionist = receptionist;
        this.clock = clock;
        this.refresh = refresh;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void preStart() {
        this.receptionist.registerSubscriber(READ_REPLICA_TOPIC, this.getSelf());
        this.getTimers().startPeriodicTimer((Object)TICK_KEY, (Object)Tick.getInstance(), this.refresh);
    }

    public void postStop() {
        this.receptionist.unregisterSubscriber(READ_REPLICA_TOPIC, this.getSelf());
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ReadReplicaRefreshMessage.class, this::handleRefreshMessage).match(ReadReplicaRemovalMessage.class, this::handleRemovalMessage).match(Tick.class, this::handleTick).build();
    }

    private void handleRemovalMessage(ReadReplicaRemovalMessage msg) {
        ReadReplicaViewRecord removed = this.clusterClientReadReplicas.remove(msg.clusterClient());
        this.log.debug("Removed shut down read replica %s -> %s", new Object[]{msg.clusterClient(), removed});
        this.sendClusterView();
    }

    private void handleRefreshMessage(ReadReplicaRefreshMessage msg) {
        this.log.debug("Received %s", new Object[]{msg});
        this.clusterClientReadReplicas.put(msg.clusterClient(), new ReadReplicaViewRecord(msg, this.clock));
        this.sendClusterView();
    }

    private void handleTick(Tick tick) {
        Instant nTicksAgo = Instant.now(this.clock).minus(this.refresh.multipliedBy(3L));
        List<ActorRef> remove = this.clusterClientReadReplicas.entrySet().stream().filter(entry -> ((ReadReplicaViewRecord)entry.getValue()).timestamp().isBefore(nTicksAgo)).peek(entry -> this.log.debug("Removing %s after inactivity", new Object[]{entry})).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!remove.isEmpty()) {
            remove.forEach(this.clusterClientReadReplicas::remove);
            this.sendClusterView();
        }
        this.parent.tell((Object)tick, this.getSelf());
    }

    private void sendClusterView() {
        this.parent.tell((Object)new ReadReplicaViewMessage(this.clusterClientReadReplicas), this.getSelf());
    }

    static class Tick {
        private static Tick instance = new Tick();

        private Tick() {
        }

        public static Tick getInstance() {
            return instance;
        }
    }
}

