/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.readreplicatopology;

import akka.actor.ActorRef;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaViewRecord;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.helpers.collection.CollectorsUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.stream.Streams;

class ReadReplicaViewMessage {
    private final Map<ActorRef, ReadReplicaViewRecord> clusterClientReadReplicas;
    static ReadReplicaViewMessage EMPTY = new ReadReplicaViewMessage(Collections.emptyMap());

    ReadReplicaViewMessage(Map<ActorRef, ReadReplicaViewRecord> clusterClientReadReplicas) {
        this.clusterClientReadReplicas = Collections.unmodifiableMap(new HashMap<ActorRef, ReadReplicaViewRecord>(clusterClientReadReplicas));
    }

    Stream<ActorRef> topologyClient(ActorRef clusterClient) {
        return Streams.ofNullable((Object)this.clusterClientReadReplicas.get(clusterClient)).map(ReadReplicaViewRecord::topologyClientActorRef);
    }

    ReadReplicaTopology toReadReplicaTopology() {
        Map knownReadReplicas = (Map)this.clusterClientReadReplicas.values().stream().map(info -> Pair.of((Object)info.memberId(), (Object)info.readReplicaInfo())).collect(CollectorsUtil.pairsToMap());
        return new ReadReplicaTopology(knownReadReplicas);
    }

    public String toString() {
        return "ReadReplicaViewMessage{clusterClientReadReplicas=" + this.clusterClientReadReplicas + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadReplicaViewMessage that = (ReadReplicaViewMessage)o;
        return Objects.equals(this.clusterClientReadReplicas, that.clusterClientReadReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.clusterClientReadReplicas);
    }
}

