/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.readreplicatopology;

import akka.actor.ActorRef;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaRefreshMessage;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.identity.MemberId;

public class ReadReplicaViewRecord {
    private final ReadReplicaInfo readReplicaInfo;
    private final Instant timestamp;
    private final ActorRef topologyClientActorRef;
    private final MemberId memberId;

    public ReadReplicaViewRecord(ReadReplicaInfo readReplicaInfo, ActorRef topologyClientActorRef, MemberId memberId, Instant timestamp) {
        this.readReplicaInfo = readReplicaInfo;
        this.timestamp = timestamp;
        this.topologyClientActorRef = topologyClientActorRef;
        this.memberId = memberId;
    }

    ReadReplicaViewRecord(ReadReplicaRefreshMessage message, Clock clock) {
        this(message.readReplicaInfo(), message.topologyClientActorRef(), message.memberId(), Instant.now(clock));
    }

    public ReadReplicaInfo readReplicaInfo() {
        return this.readReplicaInfo;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public ActorRef topologyClientActorRef() {
        return this.topologyClientActorRef;
    }

    public MemberId memberId() {
        return this.memberId;
    }

    public String toString() {
        return "ReadReplicaViewRecord{readReplicaInfo=" + this.readReplicaInfo + ", timestamp=" + this.timestamp + ", topologyClientActorRef=" + this.topologyClientActorRef + ", memberId=" + this.memberId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadReplicaViewRecord that = (ReadReplicaViewRecord)o;
        return Objects.equals(this.readReplicaInfo, that.readReplicaInfo) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.topologyClientActorRef, that.topologyClientActorRef) && Objects.equals(this.memberId, that.memberId);
    }

    public int hashCode() {
        return Objects.hash(this.readReplicaInfo, this.timestamp, this.topologyClientActorRef, this.memberId);
    }
}

