/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.system;

import akka.actor.ActorSystem;
import akka.actor.BootstrapSetup;
import akka.actor.ProviderSelection;
import akka.actor.setup.ActorSystemSetup;
import akka.actor.setup.Setup;
import akka.dispatch.ExecutionContexts;
import akka.remote.artery.tcp.SSLEngineProvider;
import akka.remote.artery.tcp.SSLEngineProviderSetup;
import com.neo4j.causalclustering.discovery.akka.system.LoggingActor;
import com.neo4j.causalclustering.discovery.akka.system.LoggingFilter;
import com.neo4j.causalclustering.discovery.akka.system.TypesafeConfigService;
import com.typesafe.config.Config;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.neo4j.logging.LogProvider;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;

public class ActorSystemFactory {
    public static final String ACTOR_SYSTEM_NAME = "cc-discovery-actor-system";
    private final LogProvider logProvider;
    private final Optional<SSLEngineProvider> sslEngineProvider;
    private final TypesafeConfigService configService;
    private final ExecutorService executor;

    public ActorSystemFactory(Optional<SSLEngineProvider> sslEngineProvider, ExecutorService executor, org.neo4j.kernel.configuration.Config config, LogProvider logProvider) {
        this.executor = executor;
        this.logProvider = logProvider;
        this.sslEngineProvider = sslEngineProvider;
        TypesafeConfigService.ArteryTransport arteryTransport = sslEngineProvider.isPresent() ? TypesafeConfigService.ArteryTransport.TLS_TCP : TypesafeConfigService.ArteryTransport.TCP;
        this.configService = new TypesafeConfigService(arteryTransport, config);
    }

    ActorSystem createActorSystem(ProviderSelection providerSelection) {
        Config tsConfig = this.configService.generate();
        ExecutionContextExecutor ec = ExecutionContexts.fromExecutor((Executor)this.executor);
        BootstrapSetup bootstrapSetup = BootstrapSetup.create((Config)tsConfig).withActorRefProvider(providerSelection).withDefaultExecutionContext((ExecutionContext)ec);
        ActorSystemSetup actorSystemSetup = ActorSystemSetup.create((Setup[])new Setup[]{bootstrapSetup});
        if (this.sslEngineProvider.isPresent()) {
            actorSystemSetup = actorSystemSetup.withSetup((Setup)SSLEngineProviderSetup.create(system -> this.sslEngineProvider.get()));
        }
        LoggingFilter.enable(this.logProvider);
        LoggingActor.enable(this.logProvider);
        ActorSystem actorSystem = ActorSystem.create((String)ACTOR_SYSTEM_NAME, (ActorSystemSetup)actorSystemSetup);
        LoggingActor.enable(actorSystem, this.logProvider);
        return actorSystem;
    }
}

