/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.system;

import akka.Done;
import akka.actor.ActorPath;
import akka.actor.ActorPaths;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.CoordinatedShutdown;
import akka.actor.Props;
import akka.actor.ProviderSelection;
import akka.cluster.Cluster;
import akka.cluster.client.ClusterClientReceptionist;
import akka.cluster.client.ClusterClientSettings;
import akka.event.EventStream;
import akka.japi.function.Procedure;
import akka.pattern.Patterns;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.OverflowStrategy;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.neo4j.causalclustering.discovery.akka.system.ActorSystemComponents;
import com.neo4j.causalclustering.discovery.akka.system.ActorSystemFactory;
import com.neo4j.causalclustering.discovery.akka.system.ClusterJoiningActor;
import com.neo4j.causalclustering.discovery.akka.system.JoinMessageFactory;
import com.neo4j.causalclustering.discovery.akka.system.LoggingActor;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.util.VisibleForTesting;

public class ActorSystemLifecycle {
    static final int SYSTEM_SHUTDOWN_TIMEOUT_S = 60;
    static final int ACTOR_SHUTDOWN_TIMEOUT_S = 15;
    private final ActorSystemFactory actorSystemFactory;
    private final RemoteMembersResolver resolver;
    private final JoinMessageFactory joinMessageFactory;
    private final Config config;
    private final Log log;
    private final LogProvider logProvider;
    @VisibleForTesting
    protected ActorSystemComponents actorSystemComponents;

    public ActorSystemLifecycle(ActorSystemFactory actorSystemFactory, RemoteMembersResolver resolver, JoinMessageFactory joinMessageFactory, Config config, LogProvider logProvider) {
        this.actorSystemFactory = actorSystemFactory;
        this.resolver = resolver;
        this.joinMessageFactory = joinMessageFactory;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
        this.logProvider = logProvider;
    }

    public void createClusterActorSystem() {
        this.actorSystemComponents = new ActorSystemComponents(this.actorSystemFactory, ProviderSelection.cluster());
        Props props = ClusterJoiningActor.props(this.cluster(), this.resolver, this.config, this.logProvider);
        this.applicationActorOf(props, "joiner").tell((Object)this.joinMessageFactory.message(), ActorRef.noSender());
    }

    public void createClientActorSystem() {
        this.actorSystemComponents = new ActorSystemComponents(this.actorSystemFactory, ProviderSelection.remote());
    }

    public void addSeenAddresses(Collection<Address> addresses) {
        this.joinMessageFactory.addSeenAddresses(addresses);
    }

    public void shutdown() throws Throwable {
        if (this.actorSystemComponents == null) {
            return;
        }
        try {
            this.doShutdown(this.actorSystemComponents);
        }
        catch (Exception e) {
            this.log.warn("Exception shutting down actor system", (Throwable)e);
            throw e;
        }
        finally {
            LoggingActor.disable(this.actorSystemComponents.actorSystem());
            this.actorSystemComponents = null;
        }
    }

    @VisibleForTesting
    void doShutdown(ActorSystemComponents actorSystemComponents) throws Exception {
        actorSystemComponents.coordinatedShutdown().runAll((CoordinatedShutdown.Reason)ShutdownByNeo4jLifecycle.INSTANCE).toCompletableFuture().get(60L, TimeUnit.SECONDS);
    }

    public <T> SourceQueueWithComplete<T> queueMostRecent(Procedure<T> sink) {
        SourceQueueWithComplete queue = (SourceQueueWithComplete)Source.queue((int)1, (OverflowStrategy)OverflowStrategy.dropHead()).to((Graph)Sink.foreach(sink)).run((Materializer)this.actorSystemComponents.materializer());
        this.actorSystemComponents.coordinatedShutdown().addTask(CoordinatedShutdown.PhaseServiceStop(), "queue-" + UUID.randomUUID(), () -> this.completeQueue(queue));
        return queue;
    }

    private <T> CompletionStage<Done> completeQueue(SourceQueueWithComplete<T> queue) {
        queue.complete();
        return queue.watchCompletion();
    }

    public ActorRef applicationActorOf(Props props, String name) {
        ActorRef actorRef = this.actorSystemComponents.actorSystem().actorOf(props, name);
        this.actorSystemComponents.coordinatedShutdown().addTask(CoordinatedShutdown.PhaseServiceUnbind(), name + "-shutdown", () -> this.gracefulShutdown(actorRef));
        return actorRef;
    }

    public ActorRef systemActorOf(Props props, String name) {
        return this.actorSystemComponents.actorSystem().actorOf(props, name);
    }

    private CompletionStage<Done> gracefulShutdown(ActorRef actor) {
        return Patterns.gracefulStop((ActorRef)actor, (Duration)Duration.ofSeconds(15L)).thenApply(ignored -> Done.done());
    }

    public EventStream eventStream() {
        return this.actorSystemComponents.actorSystem().eventStream();
    }

    public Cluster cluster() {
        return this.actorSystemComponents.cluster();
    }

    public ActorRef replicator() {
        return this.actorSystemComponents.replicator();
    }

    public ClusterClientReceptionist clusterClientReceptionist() {
        return this.actorSystemComponents.clusterClientReceptionist();
    }

    public ClusterClientSettings clusterClientSettings() {
        Set actorPaths = (Set)this.resolver.resolve(this::toActorPath, HashSet::new);
        return ClusterClientSettings.create((ActorSystem)this.actorSystemComponents.actorSystem()).withInitialContacts(actorPaths);
    }

    private ActorPath toActorPath(AdvertisedSocketAddress addr) {
        String path = String.format("%s://%s@%s/system/receptionist", "akka", "cc-discovery-actor-system", addr.toString());
        return ActorPaths.fromString((String)path);
    }

    private static class ShutdownByNeo4jLifecycle
    implements CoordinatedShutdown.Reason {
        static ShutdownByNeo4jLifecycle INSTANCE = new ShutdownByNeo4jLifecycle();

        private ShutdownByNeo4jLifecycle() {
        }
    }
}

