/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.system;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.Address;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import com.neo4j.causalclustering.discovery.akka.system.JoinMessage;
import com.neo4j.causalclustering.discovery.akka.system.TypesafeConfigService;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterJoiningActor
extends AbstractActorWithTimers {
    static final String AKKA_SCHEME = "akka";
    public static final String NAME = "joiner";
    private static final String TIMER = "join timer";
    private final Cluster cluster;
    private final RemoteMembersResolver remoteMembersResolver;
    private final Log log;
    private final Duration retry;

    public static Props props(Cluster cluster, RemoteMembersResolver resolver, Config config, LogProvider logProvider) {
        return Props.create(ClusterJoiningActor.class, (Creator & Serializable)() -> new ClusterJoiningActor(cluster, resolver, config, logProvider));
    }

    private ClusterJoiningActor(Cluster cluster, RemoteMembersResolver remoteMembersResolver, Config config, LogProvider logProvider) {
        this.cluster = cluster;
        this.remoteMembersResolver = remoteMembersResolver;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.retry = (Duration)config.get(CausalClusteringSettings.cluster_binding_retry_timeout);
    }

    public void preStart() {
        this.cluster.registerOnMemberUp(() -> {
            this.log.debug("Join successful, exiting");
            this.getContext().stop(this.getSelf());
        });
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(JoinMessage.class, this::join).build();
    }

    private void join(JoinMessage message) {
        this.log.debug("Processing: %s", new Object[]{message});
        if (!message.isReJoin()) {
            ArrayList<Address> seedNodes = this.resolve();
            this.log.info("Joining seed nodes: %s", new Object[]{seedNodes});
            this.cluster.joinSeedNodes(seedNodes);
            this.startTimer(message);
        } else if (!message.hasAddress()) {
            ArrayList<Address> seedNodes = this.resolve();
            this.getSelf().tell((Object)JoinMessage.initial(message.isReJoin(), seedNodes), this.getSelf());
        } else if (message.head().equals((Object)this.cluster.selfAddress())) {
            this.log.info("Not joining to self. Retrying next.");
            this.getSelf().tell((Object)message.tailMsg(), this.getSelf());
        } else {
            Address address = message.head();
            this.log.info("Attempting to join: %s", new Object[]{address});
            this.cluster.join(address);
            this.startTimer(message.tailMsg());
        }
    }

    private ArrayList<Address> resolve() {
        return (ArrayList)this.remoteMembersResolver.resolve(this::toAkkaAddress, ArrayList::new);
    }

    private void startTimer(JoinMessage message) {
        this.getTimers().startSingleTimer((Object)TIMER, (Object)message, this.retry);
    }

    private Address toAkkaAddress(AdvertisedSocketAddress resolvedAddress) {
        return new Address(AKKA_SCHEME, this.getContext().getSystem().name(), TypesafeConfigService.hostname((SocketAddress)resolvedAddress), resolvedAddress.getPort());
    }
}

