/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.system;

import akka.actor.AbstractActor;
import akka.actor.ActorSystem;
import akka.dispatch.RequiresMessageQueue;
import akka.event.LoggerMessageQueueSemantics;
import akka.event.Logging;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class LoggingActor
extends AbstractActor
implements RequiresMessageQueue<LoggerMessageQueueSemantics> {
    private static Map<ActorSystem, LogProvider> logProviders = new HashMap<ActorSystem, LogProvider>();
    private static LogProvider defaultLogProvider = NullLogProvider.getInstance();

    static void enable(ActorSystem system, LogProvider logProvider) {
        logProviders.put(system, logProvider);
        logProvider.getLog(LoggingActor.class).debug("Added logProvider for %s. %d LogProviders and ActorSystems remaining.", new Object[]{system.name(), logProviders.size()});
    }

    static void enable(LogProvider logProvider) {
        defaultLogProvider = logProvider;
    }

    static void disable(ActorSystem system) {
        Optional<LogProvider> removed = Optional.ofNullable(logProviders.remove(system));
        removed.ifPresent(log -> log.getLog(LoggingActor.class).debug("Removed logProvider for %s. %d LogProviders and ActorSystems remaining.", new Object[]{system.name(), logProviders.size()}));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Logging.Error.class, error -> this.getLog(error.logClass()).error(this.getMessage((Logging.LogEvent)error), error.cause())).match(Logging.Warning.class, warning -> this.getLog(warning.logClass()).warn(this.getMessage((Logging.LogEvent)warning))).match(Logging.Info.class, info -> this.getLog(info.logClass()).info(this.getMessage((Logging.LogEvent)info))).match(Logging.Debug.class, debug -> this.getLog(debug.logClass()).debug(this.getMessage((Logging.LogEvent)debug))).match(Logging.InitializeLogger.class, ignored -> this.sender().tell((Object)Logging.loggerInitialized(), this.self())).build();
    }

    private Log getLog(Class loggingClass) {
        LogProvider configuredLogProvider = logProviders.get(this.getContext().system());
        LogProvider logProvider = configuredLogProvider == null ? defaultLogProvider : configuredLogProvider;
        return logProvider.getLog(loggingClass);
    }

    private String getMessage(Logging.LogEvent error) {
        return error.message() == null ? "null" : error.message().toString();
    }
}

