/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.discovery.akka.system;

import akka.cluster.UniqueAddress;
import com.neo4j.causalclustering.discovery.akka.coretopology.CoreServerInfoForMemberId;
import com.neo4j.causalclustering.discovery.akka.directory.LeaderInfoDirectoryMessage;
import com.neo4j.causalclustering.discovery.akka.directory.ReplicatedLeaderInfo;
import com.neo4j.causalclustering.discovery.akka.marshal.BaseAkkaSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.ClusterIdSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.CoreServerInfoForMemberIdSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.CoreTopologySerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.DatabaseLeaderInfoMessageSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.LeaderInfoSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.MemberIdSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.ReadReplicaInfoSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.ReadReplicaRefreshMessageSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.ReadReplicaRemovalMessageSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.ReadReplicaTopologySerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.ReplicatedLeaderInfoSerializer;
import com.neo4j.causalclustering.discovery.akka.marshal.UniqueAddressSerializer;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaRefreshMessage;
import com.neo4j.causalclustering.discovery.akka.readreplicatopology.ReadReplicaRemovalMessage;
import com.neo4j.causalclustering.discovery.akka.system.LoggingActor;
import com.neo4j.causalclustering.discovery.akka.system.LoggingFilter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.SocketAddress;

public final class TypesafeConfigService {
    static final String DISCOVERY_SINK_DISPATCHER = "discovery-dispatcher";
    private final org.neo4j.kernel.configuration.Config config;
    private final ArteryTransport arteryTransport;

    public TypesafeConfigService(ArteryTransport arteryTransport, org.neo4j.kernel.configuration.Config config) {
        this.config = config;
        this.arteryTransport = arteryTransport;
    }

    public Config generate() {
        return ConfigFactory.empty().withFallback((ConfigMergeable)this.shutdownConfig()).withFallback((ConfigMergeable)this.transportConfig()).withFallback((ConfigMergeable)this.serializationConfig()).withFallback((ConfigMergeable)this.failureDetectorConfig()).withFallback((ConfigMergeable)this.loggingConfig()).withFallback((ConfigMergeable)this.dispatcherConfig()).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
    }

    private Config shutdownConfig() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("akka.jvm-shutdown-hooks", "off");
        configMap.put("akka.cluster.run-coordinated-shutdown-when-down", "off");
        return ConfigFactory.parseMap(configMap);
    }

    private Config transportConfig() {
        ListenSocketAddress listenAddress = (ListenSocketAddress)this.config.get(CausalClusteringSettings.discovery_listen_address);
        AdvertisedSocketAddress advertisedAddress = (AdvertisedSocketAddress)this.config.get(CausalClusteringSettings.discovery_advertised_address);
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("akka.remote.artery.enabled", true);
        configMap.put("akka.remote.artery.transport", this.arteryTransport.configValue);
        configMap.put("akka.remote.artery.canonical.hostname", TypesafeConfigService.hostname((SocketAddress)advertisedAddress));
        configMap.put("akka.remote.artery.canonical.port", advertisedAddress.getPort());
        configMap.put("akka.remote.artery.bind.hostname", TypesafeConfigService.hostname((SocketAddress)listenAddress));
        configMap.put("akka.remote.artery.bind.port", listenAddress.getPort());
        Duration bindTimeout = (Duration)this.config.get(CausalClusteringSettings.akka_bind_timeout);
        configMap.put("akka.remote.artery.bind.bind-timeout", bindTimeout.toMillis() + "ms");
        Duration connectionTimeout = (Duration)this.config.get(CausalClusteringSettings.akka_connection_timeout);
        configMap.put("akka.remote.artery.advanced.connection-timeout", connectionTimeout.toMillis() + "ms");
        Duration handshakeTimeout = (Duration)this.config.get(CausalClusteringSettings.akka_handshake_timeout);
        configMap.put("akka.remote.artery.advanced.handshake-timeout", handshakeTimeout.toMillis() + "ms");
        return ConfigFactory.parseMap(configMap);
    }

    private Config failureDetectorConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        long heartbeatIntervalMillis = ((Duration)this.config.get(CausalClusteringSettings.akka_failure_detector_heartbeat_interval)).toMillis();
        configMap.put("akka.cluster.failure-detector.heartbeat-interval", heartbeatIntervalMillis + "ms");
        Double threshold = (Double)this.config.get(CausalClusteringSettings.akka_failure_detector_threshold);
        configMap.put("akka.cluster.failure-detector.threshold", threshold);
        Integer maxSampleSize = (Integer)this.config.get(CausalClusteringSettings.akka_failure_detector_max_sample_size);
        configMap.put("akka.cluster.failure-detector.max-sample-size", maxSampleSize);
        long minStdDeviationMillis = ((Duration)this.config.get(CausalClusteringSettings.akka_failure_detector_min_std_deviation)).toMillis();
        configMap.put("akka.cluster.failure-detector.min-std-deviation", minStdDeviationMillis + "ms");
        long acceptableHeartbeatPauseMillis = ((Duration)this.config.get(CausalClusteringSettings.akka_failure_detector_acceptable_heartbeat_pause)).toMillis();
        configMap.put("akka.cluster.failure-detector.acceptable-heartbeat-pause", acceptableHeartbeatPauseMillis + "ms");
        Integer monitoredByNrOfMembers = (Integer)this.config.get(CausalClusteringSettings.akka_failure_detector_monitored_by_nr_of_members);
        configMap.put("akka.cluster.failure-detector.monitored-by-nr-of-members", monitoredByNrOfMembers);
        long expectedResponseAfterMillis = ((Duration)this.config.get(CausalClusteringSettings.akka_failure_detector_expected_response_after)).toMillis();
        configMap.put("akka.cluster.failure-detector.expected-response-after", expectedResponseAfterMillis + "ms");
        return ConfigFactory.parseMap(configMap);
    }

    private Config dispatcherConfig() {
        Integer parallelism = (Integer)this.config.get(CausalClusteringSettings.middleware_akka_sink_parallelism_level);
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("discovery-dispatcher.type", "Dispatcher");
        configMap.put("discovery-dispatcher.executor", "fork-join-executor");
        configMap.put("discovery-dispatcher.fork-join-executor.parallelism-min", parallelism);
        configMap.put("discovery-dispatcher.fork-join-executor.parallelism-factor", 1.0);
        configMap.put("discovery-dispatcher.fork-join-executor.parallelism-max", parallelism);
        configMap.put("discovery-dispatcher.throughput", 10);
        return ConfigFactory.parseMap(configMap);
    }

    static String hostname(SocketAddress socketAddress) {
        if (socketAddress.isIPv6()) {
            return "[" + socketAddress.getHostname() + "]";
        }
        return socketAddress.getHostname();
    }

    private Config serializationConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("akka.actor.allow-java-serialization", "off");
        this.addSerializer(LeaderInfo.class, LeaderInfoSerializer.class, configMap);
        this.addSerializer(ClusterId.class, ClusterIdSerializer.class, configMap);
        this.addSerializer(UniqueAddress.class, UniqueAddressSerializer.class, configMap);
        this.addSerializer(CoreServerInfoForMemberId.class, CoreServerInfoForMemberIdSerializer.class, configMap);
        this.addSerializer(ReadReplicaRefreshMessage.class, ReadReplicaRefreshMessageSerializer.class, configMap);
        this.addSerializer(MemberId.class, MemberIdSerializer.class, configMap);
        this.addSerializer(ReadReplicaInfo.class, ReadReplicaInfoSerializer.class, configMap);
        this.addSerializer(CoreTopology.class, CoreTopologySerializer.class, configMap);
        this.addSerializer(ReadReplicaRemovalMessage.class, ReadReplicaRemovalMessageSerializer.class, configMap);
        this.addSerializer(ReadReplicaTopology.class, ReadReplicaTopologySerializer.class, configMap);
        this.addSerializer(LeaderInfoDirectoryMessage.class, DatabaseLeaderInfoMessageSerializer.class, configMap);
        this.addSerializer(ReplicatedLeaderInfo.class, ReplicatedLeaderInfoSerializer.class, configMap);
        return ConfigFactory.parseMap(configMap);
    }

    private <T, M extends BaseAkkaSerializer<T>> void addSerializer(Class<T> message, Class<M> serializer, Map<String, Object> configMap) {
        String customSerializer = message.getSimpleName() + "-serializer";
        configMap.put("akka.actor.serializers." + customSerializer, serializer.getCanonicalName());
        configMap.put("akka.actor.serialization-bindings.\"" + message.getCanonicalName() + "\"", customSerializer);
    }

    private Config loggingConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("akka.loggers", Collections.singletonList(LoggingActor.class.getCanonicalName()));
        configMap.put("akka.loglevel", this.logLevel(this.config));
        configMap.put("akka.logging-filter", LoggingFilter.class.getCanonicalName());
        return ConfigFactory.parseMap(configMap);
    }

    private String logLevel(org.neo4j.kernel.configuration.Config config) {
        Boolean disableLogging = (Boolean)config.get(CausalClusteringSettings.disable_middleware_logging);
        Integer level = (Integer)config.get(CausalClusteringSettings.middleware_logging_level);
        if (disableLogging.booleanValue()) {
            return "OFF";
        }
        if (level <= Level.FINE.intValue()) {
            return "DEBUG";
        }
        if (level <= Level.INFO.intValue()) {
            return "INFO";
        }
        if (level <= Level.WARNING.intValue()) {
            return "WARNING";
        }
        return "ERROR";
    }

    public static enum ArteryTransport {
        AERON("aeron-udp"),
        TCP("tcp"),
        TLS_TCP("tls-tcp");

        private final String configValue;

        private ArteryTransport(String configValue) {
            this.configValue = configValue;
        }
    }
}

