/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.causalclustering.handlers;

import com.neo4j.causalclustering.handlers.SslClientPipelineWrapper;
import com.neo4j.causalclustering.handlers.SslServerPipelineWrapper;
import org.neo4j.causalclustering.handlers.DuplexPipelineWrapperFactory;
import org.neo4j.causalclustering.handlers.PipelineWrapper;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

public class SecurePipelineFactory
implements DuplexPipelineWrapperFactory {
    public PipelineWrapper forServer(Config config, Dependencies dependencies, LogProvider logProvider, Setting<String> policyName) {
        SslPolicy policy = this.getSslPolicy(config, dependencies, policyName);
        return new SslServerPipelineWrapper(policy);
    }

    public PipelineWrapper forClient(Config config, Dependencies dependencies, LogProvider logProvider, Setting<String> policyName) {
        SslPolicy policy = this.getSslPolicy(config, dependencies, policyName);
        return new SslClientPipelineWrapper(policy);
    }

    private SslPolicy getSslPolicy(Config config, Dependencies dependencies, Setting<String> policyNameSetting) {
        SslPolicyLoader sslPolicyLoader = (SslPolicyLoader)dependencies.resolveDependency(SslPolicyLoader.class);
        String policyName = (String)config.get(policyNameSetting);
        return sslPolicyLoader.getPolicy(policyName);
    }
}

