/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dmbs.database;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.facade.spi.ClassicCoreSPI;
import org.neo4j.graphdb.factory.module.DataSourceModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Logger;
import org.neo4j.util.Preconditions;

public final class DefaultDatabaseManager
extends LifecycleAdapter
implements DatabaseManager {
    private GraphDatabaseFacade database;
    private final PlatformModule platform;
    private final AbstractEditionModule edition;
    private final Procedures procedures;
    private final Logger log;
    private final GraphDatabaseFacade graphDatabaseFacade;
    private String databaseName;

    public DefaultDatabaseManager(PlatformModule platform, AbstractEditionModule edition, Procedures procedures, Logger log, GraphDatabaseFacade graphDatabaseFacade) {
        this.platform = platform;
        this.edition = edition;
        this.procedures = procedures;
        this.log = log;
        this.graphDatabaseFacade = graphDatabaseFacade;
    }

    public Optional<GraphDatabaseFacade> getDatabaseFacade(String name) {
        return Optional.ofNullable(this.database);
    }

    public GraphDatabaseFacade createDatabase(String databaseName) {
        Preconditions.checkState((this.database == null ? 1 : 0) != 0, (String)"Database is already created, fail to create another one.");
        this.log.log("Creating '%s' database.", new Object[]{databaseName});
        DataSourceModule dataSource = new DataSourceModule(databaseName, this.platform, this.edition, this.procedures, this.graphDatabaseFacade);
        ClassicCoreSPI spi = new ClassicCoreSPI(this.platform, dataSource, this.log, dataSource.getCoreAPIAvailabilityGuard(), this.edition.getThreadToTransactionBridge());
        this.graphDatabaseFacade.init((GraphDatabaseFacade.SPI)spi, this.edition.getThreadToTransactionBridge(), this.platform.config, dataSource.neoStoreDataSource.getTokenHolders());
        this.platform.dataSourceManager.register(dataSource.neoStoreDataSource);
        this.database = this.graphDatabaseFacade;
        this.databaseName = databaseName;
        return this.database;
    }

    public void shutdownDatabase(String ignore) {
        this.shutdownDatabase();
    }

    public void stop() {
        this.shutdownDatabase();
    }

    private void shutdownDatabase() {
        if (this.database != null) {
            this.log.log("Shutting down '%s' database.", new Object[]{this.database.databaseLayout().getDatabaseName()});
            this.database.shutdown();
        }
    }

    public List<String> listDatabases() {
        return this.databaseName == null ? Collections.emptyList() : Collections.singletonList(this.databaseName);
    }
}

