/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.list.immutable.ImmutableListFactoryImpl;
import org.eclipse.collections.impl.map.immutable.ImmutableMapFactoryImpl;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.DeferredExecutor;
import org.neo4j.scheduler.Group;

public class GraphDatabaseDependencies
implements GraphDatabaseFacadeFactory.Dependencies {
    private final Monitors monitors;
    private final LogProvider userLogProvider;
    private final ImmutableList<Class<?>> settingsClasses;
    private final ImmutableList<KernelExtensionFactory<?>> kernelExtensions;
    private final ImmutableMap<String, URLAccessRule> urlAccessRules;
    private final ImmutableList<QueryEngineProvider> queryEngineProviders;
    private final ImmutableList<Pair<DeferredExecutor, Group>> deferredExecutors;

    public static GraphDatabaseDependencies newDependencies(GraphDatabaseFacadeFactory.Dependencies deps) {
        return new GraphDatabaseDependencies(deps.monitors(), deps.userLogProvider(), Iterables.asImmutableList(deps.settingsClasses()), Iterables.asImmutableList(deps.kernelExtensions()), (ImmutableMap<String, URLAccessRule>)Iterables.asImmutableMap(deps.urlAccessRules()), (ImmutableList<QueryEngineProvider>)Iterables.asImmutableList(deps.executionEngines()), (ImmutableList<Pair<DeferredExecutor, Group>>)Iterables.asImmutableList(deps.deferredExecutors()));
    }

    public static GraphDatabaseDependencies newDependencies() {
        ImmutableList settingsClasses = ImmutableListFactoryImpl.INSTANCE.empty();
        ImmutableList kernelExtensions = Iterables.asImmutableList(GraphDatabaseDependencies.getKernelExtensions(Service.load(KernelExtensionFactory.class).iterator()));
        ImmutableMap urlAccessRules = ImmutableMapFactoryImpl.INSTANCE.of((Object)"http", (Object)URLAccessRules.alwaysPermitted(), (Object)"https", (Object)URLAccessRules.alwaysPermitted(), (Object)"ftp", (Object)URLAccessRules.alwaysPermitted(), (Object)"file", (Object)URLAccessRules.fileAccess());
        ImmutableList queryEngineProviders = Iterables.asImmutableList((Iterable)Service.load(QueryEngineProvider.class));
        ImmutableList deferredExecutors = ImmutableListFactoryImpl.INSTANCE.empty();
        return new GraphDatabaseDependencies(null, null, settingsClasses, kernelExtensions, (ImmutableMap<String, URLAccessRule>)urlAccessRules, (ImmutableList<QueryEngineProvider>)queryEngineProviders, (ImmutableList<Pair<DeferredExecutor, Group>>)deferredExecutors);
    }

    private GraphDatabaseDependencies(Monitors monitors, LogProvider userLogProvider, ImmutableList<Class<?>> settingsClasses, ImmutableList<KernelExtensionFactory<?>> kernelExtensions, ImmutableMap<String, URLAccessRule> urlAccessRules, ImmutableList<QueryEngineProvider> queryEngineProviders, ImmutableList<Pair<DeferredExecutor, Group>> deferredExecutors) {
        this.monitors = monitors;
        this.userLogProvider = userLogProvider;
        this.settingsClasses = settingsClasses;
        this.kernelExtensions = kernelExtensions;
        this.urlAccessRules = urlAccessRules;
        this.queryEngineProviders = queryEngineProviders;
        this.deferredExecutors = deferredExecutors;
    }

    public GraphDatabaseDependencies monitors(Monitors monitors) {
        return new GraphDatabaseDependencies(monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders, this.deferredExecutors);
    }

    public GraphDatabaseDependencies userLogProvider(LogProvider userLogProvider) {
        return new GraphDatabaseDependencies(this.monitors, userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders, this.deferredExecutors);
    }

    public GraphDatabaseDependencies withDeferredExecutor(DeferredExecutor executor, Group group) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders, (ImmutableList<Pair<DeferredExecutor, Group>>)Iterables.asImmutableList((Iterable)Iterables.concat((Iterable[])new Iterable[]{this.deferredExecutors, Iterables.asIterable((Object[])new Pair[]{Pair.of((Object)executor, (Object)group)})})));
    }

    public GraphDatabaseDependencies settingsClasses(List<Class<?>> settingsClasses) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, Iterables.asImmutableList(settingsClasses), this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders, this.deferredExecutors);
    }

    public GraphDatabaseDependencies settingsClasses(Class<?> ... settingsClass) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, Iterables.asImmutableList((Iterable)Iterables.concat((Iterable[])new Iterable[]{this.settingsClasses, Arrays.asList(settingsClass)})), this.kernelExtensions, this.urlAccessRules, this.queryEngineProviders, this.deferredExecutors);
    }

    public GraphDatabaseDependencies kernelExtensions(Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, Iterables.asImmutableList(kernelExtensions), this.urlAccessRules, this.queryEngineProviders, this.deferredExecutors);
    }

    public GraphDatabaseDependencies urlAccessRules(Map<String, URLAccessRule> urlAccessRules) {
        MutableMap newUrlAccessRules = this.urlAccessRules.toMap();
        newUrlAccessRules.putAll(urlAccessRules);
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, (ImmutableMap<String, URLAccessRule>)Iterables.asImmutableMap((Map)newUrlAccessRules), this.queryEngineProviders, this.deferredExecutors);
    }

    public GraphDatabaseDependencies queryEngineProviders(Iterable<QueryEngineProvider> queryEngineProviders) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.urlAccessRules, (ImmutableList<QueryEngineProvider>)Iterables.asImmutableList((Iterable)Iterables.concat((Iterable[])new Iterable[]{this.queryEngineProviders, queryEngineProviders})), this.deferredExecutors);
    }

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public LogProvider userLogProvider() {
        return this.userLogProvider;
    }

    @Override
    public Iterable<Class<?>> settingsClasses() {
        return this.settingsClasses;
    }

    @Override
    public Iterable<KernelExtensionFactory<?>> kernelExtensions() {
        return this.kernelExtensions;
    }

    @Override
    public Map<String, URLAccessRule> urlAccessRules() {
        return this.urlAccessRules.castToMap();
    }

    @Override
    public Iterable<QueryEngineProvider> executionEngines() {
        return this.queryEngineProviders;
    }

    @Override
    public Iterable<Pair<DeferredExecutor, Group>> deferredExecutors() {
        return this.deferredExecutors;
    }

    private static Iterator<KernelExtensionFactory<?>> getKernelExtensions(final Iterator<KernelExtensionFactory> parent) {
        return new Iterator<KernelExtensionFactory<?>>(){

            @Override
            public boolean hasNext() {
                return parent.hasNext();
            }

            @Override
            public KernelExtensionFactory<?> next() {
                return (KernelExtensionFactory)parent.next();
            }
        };
    }
}

