/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.time.Clock;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.DynamicLocksFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.LocksFactory;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.CommunityLocksFactory;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.lock.ResourceType;

public final class EditionLocksFactories {
    public static Locks createLockManager(LocksFactory locksFactory, Config config, Clock clock) {
        return locksFactory.newInstance(config, clock, (ResourceType[])ResourceTypes.values());
    }

    public static LocksFactory createLockFactory(Config config, LogService logging) {
        String key = (String)config.get(GraphDatabaseSettings.lock_manager);
        for (DynamicLocksFactory candidate : Service.load(DynamicLocksFactory.class)) {
            String candidateId = (String)candidate.getKeys().iterator().next();
            if (key.equals(candidateId)) {
                return candidate;
            }
            if (!"".equals(key)) continue;
            logging.getInternalLog(CommunityEditionModule.class).info("No locking implementation specified, defaulting to '" + candidateId + "'");
            return candidate;
        }
        if ("community".equals(key)) {
            return new CommunityLocksFactory();
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            logging.getInternalLog(CommunityEditionModule.class).info("No locking implementation specified, defaulting to 'community'");
            return new CommunityLocksFactory();
        }
        throw new IllegalArgumentException("No lock manager found with the name '" + key + "'.");
    }
}

