/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.util.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.module.ModularDatabaseCreationContext;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.ProcedureGDSFactory;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.context.DatabaseEditionContext;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.kernel.DatabaseCreationContext;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.StoreId;

public class DataSourceModule {
    public final NeoStoreDataSource neoStoreDataSource;
    public final Supplier<InwardKernel> kernelAPI;
    public final Supplier<StoreId> storeId;
    public final CoreAPIAvailabilityGuard coreAPIAvailabilityGuard;

    public DataSourceModule(String databaseName, PlatformModule platformModule, AbstractEditionModule editionModule, Procedures procedures, GraphDatabaseFacade graphDatabaseFacade) {
        platformModule.diagnosticsManager.prependProvider((DiagnosticsProvider)platformModule.config);
        DatabaseEditionContext editionContext = editionModule.createDatabaseContext(databaseName);
        ModularDatabaseCreationContext context = new ModularDatabaseCreationContext(databaseName, platformModule, editionContext, procedures, graphDatabaseFacade);
        this.neoStoreDataSource = new NeoStoreDataSource((DatabaseCreationContext)context);
        this.coreAPIAvailabilityGuard = context.getCoreAPIAvailabilityGuard();
        this.storeId = () -> ((NeoStoreDataSource)this.neoStoreDataSource).getStoreId();
        this.kernelAPI = () -> ((NeoStoreDataSource)this.neoStoreDataSource).getKernel();
        ProcedureGDSFactory gdsFactory = new ProcedureGDSFactory(platformModule, this, this.coreAPIAvailabilityGuard, context.getTokenHolders(), editionModule.getThreadToTransactionBridge());
        procedures.registerComponent(GraphDatabaseService.class, gdsFactory::apply, true);
    }

    public CoreAPIAvailabilityGuard getCoreAPIAvailabilityGuard() {
        return this.coreAPIAvailabilityGuard;
    }
}

