/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.EditionLocksFactories;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.DefaultEditionModule;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.graphdb.factory.module.id.IdContextFactoryBuilder;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.api.security.provider.NoAuthSecurityProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.DelegatingTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.ReadOnly;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.LocksFactory;
import org.neo4j.kernel.impl.locking.SimpleStatementLocksFactory;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.udc.UsageData;

public class CommunityEditionModule
extends DefaultEditionModule {
    public static final String COMMUNITY_SECURITY_MODULE_ID = "community-security-module";

    public CommunityEditionModule(PlatformModule platformModule) {
        Dependencies dependencies = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        PageCache pageCache = platformModule.pageCache;
        DataSourceManager dataSourceManager = platformModule.dataSourceManager;
        LifeSupport life = platformModule.life;
        life.add((Lifecycle)platformModule.dataSourceManager);
        this.watcherServiceFactory = databaseDir -> this.createFileSystemWatcherService(fileSystem, (File)databaseDir, logging, platformModule.jobScheduler, config, this.fileWatcherFileNameFilter());
        this.accessCapability = (Boolean)config.get(GraphDatabaseSettings.read_only) != false ? new ReadOnly() : new CanWrite();
        dependencies.satisfyDependency((Object)SslPolicyLoader.create((Config)config, (LogProvider)logging.getInternalLogProvider()));
        LocksFactory lockFactory = EditionLocksFactories.createLockFactory(config, logging);
        this.locksSupplier = () -> EditionLocksFactories.createLockManager(lockFactory, config, (Clock)platformModule.clock);
        this.statementLocksFactoryProvider = locks -> this.createStatementLocksFactory((Locks)locks, config, logging);
        this.threadToTransactionBridge = (ThreadToStatementContextBridge)dependencies.satisfyDependency((Object)new ThreadToStatementContextBridge(this.getGlobalAvailabilityGuard((Clock)platformModule.clock, logging, platformModule.config)));
        this.idContextFactory = this.createIdContextFactory(platformModule, fileSystem);
        this.tokenHoldersProvider = this.createTokenHolderProvider(platformModule);
        File kernelContextDirectory = platformModule.storeLayout.storeDirectory();
        dependencies.satisfyDependency((Object)this.createKernelData(fileSystem, pageCache, kernelContextDirectory, config, life, dataSourceManager));
        this.commitProcessFactory = new CommunityCommitProcessFactory();
        this.headerInformationFactory = this.createHeaderInformationFactory();
        this.schemaWriteGuard = this.createSchemaWriteGuard();
        this.transactionStartTimeout = ((Duration)config.get(GraphDatabaseSettings.transaction_start_timeout)).toMillis();
        this.constraintSemantics = this.createSchemaRuleVerifier();
        this.ioLimiter = IOLimiter.UNLIMITED;
        this.connectionTracker = (NetworkConnectionTracker)dependencies.satisfyDependency((Object)this.createConnectionTracker());
        this.publishEditionInfo((UsageData)dependencies.resolveDependency(UsageData.class), platformModule.databaseInfo, config);
    }

    protected Function<String, TokenHolders> createTokenHolderProvider(PlatformModule platform) {
        Config config = platform.config;
        DataSourceManager dataSourceManager = platform.dataSourceManager;
        return ignored -> new TokenHolders((TokenHolder)new DelegatingTokenHolder(CommunityEditionModule.createPropertyKeyCreator(config, (Supplier<Kernel>)dataSourceManager), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder(CommunityEditionModule.createLabelIdCreator(config, (Supplier<Kernel>)dataSourceManager), "Label"), (TokenHolder)new DelegatingTokenHolder(CommunityEditionModule.createRelationshipTypeCreator(config, (Supplier<Kernel>)dataSourceManager), "RelationshipType"));
    }

    protected IdContextFactory createIdContextFactory(PlatformModule platformModule, FileSystemAbstraction fileSystem) {
        return IdContextFactoryBuilder.of(fileSystem, platformModule.jobScheduler).build();
    }

    protected Predicate<String> fileWatcherFileNameFilter() {
        return CommunityEditionModule.communityFileWatcherFileNameFilter();
    }

    static Predicate<String> communityFileWatcherFileNameFilter() {
        return Predicates.any((Predicate[])new Predicate[]{fileName -> fileName.startsWith("neostore.transaction.db"), fileName -> fileName.startsWith("index.db")});
    }

    protected ConstraintSemantics createSchemaRuleVerifier() {
        return new StandardConstraintSemantics();
    }

    protected StatementLocksFactory createStatementLocksFactory(Locks locks, Config config, LogService logService) {
        return new SimpleStatementLocksFactory(locks);
    }

    protected SchemaWriteGuard createSchemaWriteGuard() {
        return SchemaWriteGuard.ALLOW_ALL_WRITES;
    }

    protected static TokenCreator createRelationshipTypeCreator(Config config, Supplier<Kernel> kernelSupplier) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultRelationshipTypeCreator(kernelSupplier);
    }

    protected static TokenCreator createPropertyKeyCreator(Config config, Supplier<Kernel> kernelSupplier) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultPropertyTokenCreator(kernelSupplier);
    }

    protected static TokenCreator createLabelIdCreator(Config config, Supplier<Kernel> kernelSupplier) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultLabelIdCreator(kernelSupplier);
    }

    private KernelData createKernelData(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, Config config, LifeSupport life, DataSourceManager dataSourceManager) {
        return (KernelData)life.add((Lifecycle)new KernelData(fileSystem, pageCache, storeDir, config, dataSourceManager));
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return TransactionHeaderInformationFactory.DEFAULT;
    }

    @Override
    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
    }

    @Override
    public void createSecurityModule(PlatformModule platformModule, Procedures procedures) {
        if (((Boolean)platformModule.config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            SecurityModule securityModule = CommunityEditionModule.setupSecurityModule(platformModule, this, platformModule.logging.getUserLog(this.getClass()), procedures, COMMUNITY_SECURITY_MODULE_ID);
            platformModule.life.add((Lifecycle)securityModule);
            this.securityProvider = securityModule;
        } else {
            NoAuthSecurityProvider noAuthSecurityProvider = NoAuthSecurityProvider.INSTANCE;
            platformModule.life.add((Lifecycle)noAuthSecurityProvider);
            this.securityProvider = noAuthSecurityProvider;
        }
    }
}

