/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.id;

import java.util.function.Function;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.DefaultIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.FeatureToggles;

public class IdContextFactory {
    private static final boolean ID_BUFFERING_FLAG = FeatureToggles.flag(IdContextFactory.class, (String)"safeIdBuffering", (boolean)true);
    private final JobScheduler jobScheduler;
    private final Function<String, IdGeneratorFactory> idFactoryProvider;
    private final IdTypeConfigurationProvider idTypeConfigurationProvider;
    private final IdReuseEligibility eligibleForIdReuse;
    private final Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper;

    IdContextFactory(JobScheduler jobScheduler, Function<String, IdGeneratorFactory> idFactoryProvider, IdTypeConfigurationProvider idTypeConfigurationProvider, IdReuseEligibility eligibleForIdReuse, Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper) {
        this.jobScheduler = jobScheduler;
        this.idFactoryProvider = idFactoryProvider;
        this.idTypeConfigurationProvider = idTypeConfigurationProvider;
        this.eligibleForIdReuse = eligibleForIdReuse;
        this.factoryWrapper = factoryWrapper;
    }

    public DatabaseIdContext createIdContext(String databaseName) {
        return ID_BUFFERING_FLAG ? this.createBufferingIdContext(this.idFactoryProvider, this.jobScheduler, databaseName) : this.createDefaultIdContext(this.idFactoryProvider, databaseName);
    }

    private DatabaseIdContext createDefaultIdContext(Function<String, ? extends IdGeneratorFactory> idGeneratorFactoryProvider, String databaseName) {
        return this.createIdContext(idGeneratorFactoryProvider.apply(databaseName), (IdController)IdContextFactory.createDefaultIdController());
    }

    private DatabaseIdContext createBufferingIdContext(Function<String, ? extends IdGeneratorFactory> idGeneratorFactoryProvider, JobScheduler jobScheduler, String databaseName) {
        IdGeneratorFactory idGeneratorFactory = idGeneratorFactoryProvider.apply(databaseName);
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory(idGeneratorFactory, this.eligibleForIdReuse, this.idTypeConfigurationProvider);
        BufferedIdController bufferingController = IdContextFactory.createBufferedIdController(bufferingIdGeneratorFactory, jobScheduler);
        return this.createIdContext((IdGeneratorFactory)bufferingIdGeneratorFactory, (IdController)bufferingController);
    }

    private DatabaseIdContext createIdContext(IdGeneratorFactory idGeneratorFactory, IdController idController) {
        return new DatabaseIdContext(this.factoryWrapper.apply(idGeneratorFactory), idController);
    }

    private static BufferedIdController createBufferedIdController(BufferingIdGeneratorFactory idGeneratorFactory, JobScheduler scheduler) {
        return new BufferedIdController(idGeneratorFactory, scheduler);
    }

    private static DefaultIdController createDefaultIdController() {
        return new DefaultIdController();
    }
}

