/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.collector.DataCollectorModule;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.ValueMapper;

public class DataCollectorManager
extends LifecycleAdapter {
    private final DataSourceManager dataSourceManager;
    private final JobScheduler jobScheduler;
    private final Procedures procedures;
    private final Monitors monitors;
    private final Config config;
    private final List<AutoCloseable> dataCollectors;

    public DataCollectorManager(DataSourceManager dataSourceManager, JobScheduler jobScheduler, Procedures procedures, Monitors monitors, Config config) {
        this.dataSourceManager = dataSourceManager;
        this.jobScheduler = jobScheduler;
        this.procedures = procedures;
        this.monitors = monitors;
        this.config = config;
        this.dataCollectors = new ArrayList<AutoCloseable>();
    }

    public void start() throws Throwable {
        NeoStoreDataSource dataSource = this.dataSourceManager.getDataSource();
        EmbeddedProxySPI embeddedProxySPI = (EmbeddedProxySPI)dataSource.getDependencyResolver().resolveDependency(EmbeddedProxySPI.class, DependencyResolver.SelectionStrategy.ONLY);
        this.dataCollectors.add(DataCollectorModule.setupDataCollector((Procedures)this.procedures, (JobScheduler)this.jobScheduler, (Kernel)dataSource.getKernel(), (Monitors)this.monitors, (ValueMapper.JavaMapper)new DefaultValueMapper(embeddedProxySPI), (Config)this.config));
    }

    public void stop() throws Throwable {
        try {
            IOUtils.closeAll(this.dataCollectors);
        }
        finally {
            this.dataCollectors.clear();
        }
    }
}

